/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Set;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddScopeToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddScopeToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    AddScopeToClientMetadata action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddScopeToClientMetadata();
        this.action.initialize();
    }

    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        return new AddScopeToClientMetadata();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullDefault() {
        this.action = new AddScopeToClientMetadata();
        this.action.setDefaultScope(null);
    }

    @Test
    public void testNullScope() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Set)output.getScope(), (Set)this.action.getDefaultScope());
    }

    @Test
    public void testEmptyScope() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setScope(new Scope());
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Set)output.getScope(), (Set)this.action.getDefaultScope());
    }

    @Test
    public void testNullScopeCustomDefault() throws ComponentInitializationException {
        this.action = new AddScopeToClientMetadata();
        Scope defaultScope = new Scope(new Scope.Value[]{OIDCScopeValue.OPENID, OIDCScopeValue.ADDRESS});
        this.action.setDefaultScope(defaultScope);
        this.action.initialize();
        OIDCClientMetadata input = new OIDCClientMetadata();
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Set)output.getScope(), (Set)defaultScope);
    }

    @Test
    public void testSetScope() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        Scope scope = new Scope(new Scope.Value[]{OIDCScopeValue.OPENID, OIDCScopeValue.ADDRESS});
        input.setScope(scope);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Set)output.getScope(), (Set)scope);
    }
}

