/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddNonceToIDToken;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AddNonceToIDTokenTest
extends BaseOIDCResponseActionTest {
    private AddNonceToIDToken action;

    private void init() throws ComponentInitializationException {
        this.action = new AddNonceToIDToken();
        this.action.initialize();
    }

    @Test
    public void testNoIdToken() throws ComponentInitializationException, ParseException {
        this.init();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, ParseException {
        this.init();
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)this.respCtx.getIDToken().getNonce(), (Object)this.request.getNonce());
    }
}

