/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddAuthTimeToIDToken;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddAuthTimeToIDTokenTest
extends BaseOIDCResponseActionTest {
    private AddAuthTimeToIDToken action;

    @BeforeMethod
    private void init() throws ComponentInitializationException {
        this.action = new AddAuthTimeToIDToken();
        this.action.initialize();
    }

    @Test
    public void testNoCtx() throws ComponentInitializationException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getIDToken().getAuthenticationTime());
    }

    @Test
    public void testSuccess2() throws ComponentInitializationException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        Instant now = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        this.respCtx.setAuthTime(now);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)this.respCtx.getIDToken().getAuthenticationTime(), (Object)Date.from(now));
    }
}

