/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractOIDCAuthenticationResponseActionTest {
    private MockOIDCResponseAction action;
    private RequestContext requestCtx;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.action = new MockOIDCResponseAction();
        AuthenticationRequest req = AuthenticationRequest.parse((String)"response_type=code&client_id=s6BhdRkqt3&login_hint=foo&redirect_uri=https%3A%2F%2Fclient.example.org%2Fcb&scope=openid%20profile&state=af0ifjsldkj&nonce=n-0S6_WzA2Mj");
        this.requestCtx = new RequestContextBuilder().setInboundMessage((Object)req).buildRequestContext();
        MessageContext msgCtx = new MessageContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        prc.getInboundMessageContext().addSubcontext((BaseContext)new OIDCMetadataContext());
        prc.setOutboundMessageContext(msgCtx);
        this.action.initialize();
    }

    @Test
    public void testNoOutboundMessageContext() throws Exception {
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        prc.setOutboundMessageContext(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoOidcResponseContext() throws Exception {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testSuccess() throws Exception {
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        prc.getOutboundMessageContext().addSubcontext((BaseContext)new OIDCAuthenticationResponseContext());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    class MockOIDCResponseAction
    extends AbstractOIDCAuthenticationResponseAction {
        MockOIDCResponseAction() {
        }
    }
}

