/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationRequestAction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.Test;

public class AbstractOIDCAuthenticationRequestActionTest {
    @Test
    public void testNoInboundMessageContext() throws Exception {
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        prc.setInboundMessageContext(null);
        MockOIDCRequestAction action = new MockOIDCRequestAction();
        action.initialize();
        Event event = action.execute(requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoInboundMessage() throws Exception {
        RequestContext requestCtx = new RequestContextBuilder().setInboundMessage(null).buildRequestContext();
        MockOIDCRequestAction action = new MockOIDCRequestAction();
        action.initialize();
        Event event = action.execute(requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testSuccess() throws Exception {
        AuthenticationRequest req = AuthenticationRequest.parse((String)"response_type=code&client_id=s6BhdRkqt3&login_hint=foo&redirect_uri=https%3A%2F%2Fclient.example.org%2Fcb&scope=openid%20profile&state=af0ifjsldkj&nonce=n-0S6_WzA2Mj");
        RequestContext requestCtx = new RequestContextBuilder().setInboundMessage((Object)req).buildRequestContext();
        MockOIDCRequestAction action = new MockOIDCRequestAction();
        action.initialize();
        Event event = action.execute(requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    class MockOIDCRequestAction
    extends AbstractOIDCAuthenticationRequestAction {
        MockOIDCRequestAction() {
        }
    }
}

