/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import java.io.IOException;
import java.security.PrivateKey;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcClientAuthenticationFlowTest;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.storage.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class ClientCredentialsTokenFlowTest
extends AbstractOidcClientAuthenticationFlowTest {
    public static final String FLOW_ID = "oidc/token";
    private final Scope scope = Scope.parse((String)"profile email");
    private final String resource = "https://rp.example.org";
    private final String resourceSaml = "https://resource.example.org";
    @Autowired
    @Qualifier(value="shibboleth.StorageService")
    StorageService storageService;

    public ClientCredentialsTokenFlowTest() {
        super(FLOW_ID);
    }

    @AfterMethod
    public void tearDown() throws IOException {
        this.removeMetadata(this.storageService, this.clientId);
        this.removeMetadata(this.storageService, "https://rp.example.org");
    }

    @Test
    public void testUntrustedClient() throws IOException, ParseException {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId + "2", this.scope, "https://rp.example.org"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testInvalidClientSecret() throws ParseException, IOException {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org"));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret + "2");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client");
    }

    @Test
    public void testInvalidAudience() throws ParseException, IOException {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org/invalid"));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, null, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_target");
    }

    @Test
    public void testNoScope() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org"));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, null, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertNull((Object)response.getTokens().getBearerAccessToken().getScope());
        this.verifyClaims(null, (AccessToken)response.getTokens().getBearerAccessToken(), this.clientId, new Scope(), Collections.singletonList("https://rp.example.org"), "eduPersonScopedAffiliation");
    }

    @Test
    public void testNoScopeUnverifiedClient() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org"));
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertNull((Object)response.getTokens().getBearerAccessToken().getScope());
        this.verifyClaims(null, (AccessToken)response.getTokens().getBearerAccessToken(), this.clientId, new Scope(), Collections.singletonList("https://rp.example.org"), "eduPersonScopedAffiliation");
    }

    @Test
    public void testNoScopeUnverifiedClientBadAudience() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org/invalid"));
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_target");
    }

    @Test
    public void testRequestedScope() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org"));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertEquals((Set)response.getTokens().getBearerAccessToken().getScope(), (Set)this.scope);
        this.verifyClaims(null, (AccessToken)response.getTokens().getBearerAccessToken(), this.clientId, this.scope, Collections.singletonList("https://rp.example.org"), "email", "eduPersonScopedAffiliation");
    }

    @Test
    public void testRequestedScopeUnverifiedClient() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org"));
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertNull((Object)response.getTokens().getBearerAccessToken().getScope());
        this.verifyClaims(null, (AccessToken)response.getTokens().getBearerAccessToken(), this.clientId, new Scope(), Collections.singletonList("https://rp.example.org"), "email", "eduPersonScopedAffiliation");
    }

    @Test
    public void testRequestedScopeNoAudienceJWT() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId + "JWT", this.scope, null));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.storeMetadata(this.storageService, "https://rp.example.org", null, null, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertEquals((Set)response.getTokens().getBearerAccessToken().getScope(), (Set)this.scope);
        this.verifyClaims("JWT", (AccessToken)response.getTokens().getBearerAccessToken(), this.clientId, this.scope, Collections.singletonList("https://rp.example.org"), "email", "eduPersonScopedAffiliation");
    }

    @Test
    public void testRequestedScopeJWT() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org"));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.storeMetadata(this.storageService, "https://rp.example.org", null, null, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertEquals((Set)response.getTokens().getBearerAccessToken().getScope(), (Set)this.scope);
        this.verifyClaims("JWT", (AccessToken)response.getTokens().getBearerAccessToken(), this.clientId, this.scope, Collections.singletonList("https://rp.example.org"), "email", "eduPersonScopedAffiliation");
    }

    @Test
    public void testRequestedScopeJWTUnverifiedClient() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org"));
        this.storeMetadata(this.storageService, "https://rp.example.org", null, null, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertNull((Object)response.getTokens().getBearerAccessToken().getScope());
        this.verifyClaims("JWT", (AccessToken)response.getTokens().getBearerAccessToken(), this.clientId, new Scope(), Collections.singletonList("https://rp.example.org"), "eduPersonScopedAffiliation");
    }

    @Test
    public void testRequestedScopeJWTEncrypted() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org"));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.storeMetadata(this.storageService, "https://rp.example.org", null, null, JWSAlgorithm.RS256, JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A128GCM, ClientAuthenticationMethod.CLIENT_SECRET_BASIC, JWSAlgorithm.RS256, this.rsaPublicKey, (String[])null);
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertEquals((Set)response.getTokens().getBearerAccessToken().getScope(), (Set)this.scope);
        this.verifyClaims("JWE", (AccessToken)response.getTokens().getBearerAccessToken(), this.clientId, this.scope, Collections.singletonList("https://rp.example.org"), "email", "eduPersonScopedAffiliation");
    }

    @Test
    public void testInvalidSecretJWTAuthn() throws Exception {
        ClientSecretJWT clientAuth = this.buildSecretJwtAuth(this.clientSecret + "invalid");
        FlowExecutionResult result = this.launchWithJwtAuthentication((JWTAuthentication)clientAuth, JWSAlgorithm.HS256);
        this.assertErrorCode(result, "invalid_client");
    }

    @Test
    public void testValidSecretJWTAuthn() throws Exception {
        ClientSecretJWT clientAuth = this.buildSecretJwtAuth(this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication((JWTAuthentication)clientAuth, JWSAlgorithm.HS256);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertEquals((Set)response.getTokens().getBearerAccessToken().getScope(), (Set)this.scope);
        this.verifyClaims(null, (AccessToken)response.getTokens().getBearerAccessToken(), this.clientId, this.scope, Collections.singletonList("https://rp.example.org"), "email", "eduPersonScopedAffiliation");
    }

    @Test
    public void testSaml() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.clientIdSaml, this.scope, "https://resource.example.org"));
        this.setBasicAuth(this.clientIdSaml, this.clientSecretSaml);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertEquals((Set)response.getTokens().getBearerAccessToken().getScope(), (Set)this.scope);
        this.verifyClaims("JWT", (AccessToken)response.getTokens().getBearerAccessToken(), this.clientIdSaml, this.scope, Collections.singletonList("https://resource.example.org"), "email", "eduPersonScopedAffiliation");
    }

    private AccessTokenClaimsSet unwrapAccessToken(AccessTokenResponse tokenResponse) {
        AccessToken accessToken = tokenResponse.getTokens().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        try {
            return AccessTokenClaimsSet.parse((String)accessToken.getValue(), (DataSealer)this.getDataSealer());
        }
        catch (ParseException | DataSealerException e) {
            return null;
        }
    }

    protected FlowExecutionResult launchWithJwtAuthentication(JWTAuthentication authnMethod, JWSAlgorithm algorithm) throws Exception {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT, new String[0]);
        Map<String, String> requestParameters = this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org");
        this.populateClientAssertionParams(requestParameters, authnMethod);
        this.setHttpFormRequest("POST", requestParameters);
        return this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
    }

    @Override
    protected FlowExecutionResult launchWithJwtAuthentication(SignedJWT jwt, JWSAlgorithm algorithm, ClientAuthenticationMethod method) throws Exception {
        if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.equals((Object)method)) {
            this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, algorithm, method, new String[0]);
        } else {
            this.storeMetadata(this.storageService, this.clientId, null, this.scope, algorithm, method, null, this.rsaPublicKey, new String[0]);
        }
        Map<String, String> requestParameters = this.createRequestParameters(this.clientId, this.scope, "https://rp.example.org");
        this.populateClientAssertionParams(requestParameters, jwt);
        this.setHttpFormRequest("POST", requestParameters);
        return this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
    }

    protected Map<String, String> createRequestParameters(String clientId, Scope s, String r) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addNonNullValue(parameters, "grant_type", GrantType.CLIENT_CREDENTIALS.getValue());
        if (s != null) {
            this.addNonNullValue(parameters, "scope", s.toString());
        }
        if (r != null) {
            this.addNonNullValue(parameters, "resource", r);
        }
        return parameters;
    }

    private void addNonNullValue(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    @Override
    protected Pair<String, String> getErrorDetaisForJWTValidation() {
        return new Pair((Object)"invalid_client", (Object)"Client authentication failed");
    }

    private void verifyClaims(@Nullable String type, @Nonnull AccessToken token, @Nonnull String cid, @Nonnull Scope s, @Nonnull @NonnullElements Collection<String> audiences, String ... customClaims) throws ParseException, DataSealerException, JOSEException {
        JWTClaimsSet claims;
        if (type == null) {
            AccessTokenClaimsSet at = AccessTokenClaimsSet.parse((String)token.getValue(), (DataSealer)this.getDataSealer());
            Assert.assertNotNull((Object)at);
            Assert.assertEquals((String)at.getACR(), null);
            Assert.assertEquals((Collection)at.getAudience(), audiences);
            Assert.assertTrue((boolean)at.getAuthenticationTime().isBefore(Instant.now()));
            Assert.assertEquals((String)at.getClientID().getValue(), (String)cid);
            Assert.assertEquals((Object)at.getExp(), (Object)at.getIssuedAt().plusSeconds(600L));
            Assert.assertEquals((String)at.getIssuer(), (String)"https://op.example.org");
            Assert.assertTrue((boolean)at.getIssuedAt().isBefore(Instant.now()));
            Assert.assertEquals((Set)at.getScope(), (Set)s);
            Assert.assertEquals((String)at.getSubject(), (String)cid);
            if (customClaims != null) {
                for (String c : customClaims) {
                    Assert.assertNull((Object)at.getClaimsSet().getClaim(c));
                }
            }
            return;
        }
        if ("JWE".equals(type)) {
            EncryptedJWT encrypted = EncryptedJWT.parse((String)token.getValue());
            RSADecrypter decrypter = new RSADecrypter((PrivateKey)this.rsaPrivateKey);
            encrypted.decrypt((JWEDecrypter)decrypter);
            claims = SignedJWT.parse((String)encrypted.getPayload().toString()).getJWTClaimsSet();
        } else if ("JWT".equals(type)) {
            claims = SignedJWT.parse((String)token.getValue()).getJWTClaimsSet();
        } else {
            throw new RuntimeException("Bad token type");
        }
        Assert.assertNotNull((Object)claims);
        Assert.assertEquals((Object)claims.getClaim("acr"), null);
        Assert.assertEquals((Collection)claims.getAudience(), audiences);
        Assert.assertTrue((boolean)claims.getDateClaim("auth_time").toInstant().isBefore(Instant.now()));
        Assert.assertEquals((String)claims.getStringClaim("client_id"), (String)cid);
        Assert.assertEquals((Object)claims.getExpirationTime().toInstant(), (Object)claims.getIssueTime().toInstant().plusSeconds(600L));
        Assert.assertEquals((String)claims.getIssuer(), (String)"https://op.example.org");
        Assert.assertTrue((boolean)claims.getIssueTime().toInstant().isBefore(Instant.now()));
        Assert.assertEquals((String)claims.getStringClaim("scope"), (String)s.toString());
        Assert.assertEquals((String)claims.getSubject(), (String)cid);
        if (customClaims != null) {
            for (String c : customClaims) {
                Assert.assertNotNull((Object)claims.getClaim(c));
            }
        }
    }

    @Override
    protected void assertSuccessResponse(FlowExecutionResult result) {
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getBearerAccessToken());
        Assert.assertEquals((long)response.getTokens().getBearerAccessToken().getLifetime(), (long)600L);
        Assert.assertEquals((Set)response.getTokens().getBearerAccessToken().getScope(), (Set)this.scope);
    }
}

