/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcApiFlowTest;
import net.shibboleth.utilities.java.support.collection.Pair;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractOidcClientAuthenticationFlowTest
extends AbstractOidcApiFlowTest {
    String clientId = "mockClientId";
    String clientSecret = "1234567890mockClientSecretmockClientSecretmockClientSecret";
    String clientIdSaml = "mockSamlClientId";
    String clientSecretSaml = "mockClientSecretmockClientSecretmockClientSecret";
    String jwtAud = "http://localhost";
    RSAPrivateKey rsaPrivateKey;
    RSAPublicKey rsaPublicKey;

    public AbstractOidcClientAuthenticationFlowTest(String flowId) {
        super(flowId);
    }

    @BeforeClass
    public void initKeys() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.genKeyPair();
        this.rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        this.rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
    }

    protected void populateClientAssertionParams(Map<String, String> requestParameters, SignedJWT jwt) {
        requestParameters.put("client_assertion", jwt.serialize());
        requestParameters.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
    }

    @Test
    public void testInvalidSecretJWT_missingSub() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createSecretJWT(this.claimsSetMissingSub(), this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testInvalidSecretJWT_missingIss() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createSecretJWT(this.claimsSetMissingIss(), this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testInvalidSecretJWT_missingAud() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createSecretJWT(this.claimsSetMissingAud(), this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testInvalidSecretJWT_missingExp() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createSecretJWT(this.claimsSetMissingExp(), this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testInvalidSecretJWT_expiredExp() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createSecretJWT(this.claimsSetExpiredExp(), this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.assertErrorCode(result, (String)this.getErrorDetaisForJWTValidation().getFirst());
        this.assertErrorDescriptionContains(result, (String)this.getErrorDetaisForJWTValidation().getSecond());
    }

    @Test
    public void testInvalidSecretJWT_issuedInTheFuture() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createSecretJWT(this.claimsSetIssuedInTheFuture(), this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.assertErrorCode(result, (String)this.getErrorDetaisForJWTValidation().getFirst());
        this.assertErrorDescriptionContains(result, (String)this.getErrorDetaisForJWTValidation().getSecond());
    }

    @Test
    public void testInvalidSecretJWT_missingJti() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createSecretJWT(this.claimsSetMissingJti(), this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.assertErrorCode(result, (String)this.getErrorDetaisForJWTValidation().getFirst());
        this.assertErrorDescriptionContains(result, (String)this.getErrorDetaisForJWTValidation().getSecond());
    }

    @Test
    public void testInvalidSecretJWT_replayJti() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createSecretJWT(this.validClaimsSet(), this.clientSecret);
        this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.assertErrorCode(result, (String)this.getErrorDetaisForJWTValidation().getFirst());
        this.assertErrorDescriptionContains(result, (String)this.getErrorDetaisForJWTValidation().getSecond());
    }

    @Test
    public void testValidSecretJWT() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createSecretJWT(this.validClaimsSet(), this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.assertSuccessResponse(result);
    }

    @Test
    public void testInvalidPrivateKeyJWT_missingSub() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createPrivateKeyJWT(this.claimsSetMissingSub(), this.rsaPrivateKey);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testInvalidPrivateKeyJWT_missingIss() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createPrivateKeyJWT(this.claimsSetMissingIss(), this.rsaPrivateKey);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testInvalidPrivateKeyJWT_missingAud() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createPrivateKeyJWT(this.claimsSetMissingAud(), this.rsaPrivateKey);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testInvalidPrivateKeyJWT_missingExp() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createPrivateKeyJWT(this.claimsSetMissingExp(), this.rsaPrivateKey);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testInvalidPrivateKeyJWT_expiredExp() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createPrivateKeyJWT(this.claimsSetExpiredExp(), this.rsaPrivateKey);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.assertErrorCode(result, (String)this.getErrorDetaisForJWTValidation().getFirst());
        this.assertErrorDescriptionContains(result, (String)this.getErrorDetaisForJWTValidation().getSecond());
    }

    @Test
    public void testInvalidPrivateKeyJWT_issuedInTheFuture() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createPrivateKeyJWT(this.claimsSetIssuedInTheFuture(), this.rsaPrivateKey);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.assertErrorCode(result, (String)this.getErrorDetaisForJWTValidation().getFirst());
        this.assertErrorDescriptionContains(result, (String)this.getErrorDetaisForJWTValidation().getSecond());
    }

    @Test
    public void testInvalidPrivateKeyJWT_missingJti() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createPrivateKeyJWT(this.claimsSetMissingJti(), this.rsaPrivateKey);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.assertErrorCode(result, (String)this.getErrorDetaisForJWTValidation().getFirst());
        this.assertErrorDescriptionContains(result, (String)this.getErrorDetaisForJWTValidation().getSecond());
    }

    @Test
    public void testInvalidPrivateKeyJWT_replayJti() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createPrivateKeyJWT(this.validClaimsSet(), this.rsaPrivateKey);
        this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.assertErrorCode(result, (String)this.getErrorDetaisForJWTValidation().getFirst());
        this.assertErrorDescriptionContains(result, (String)this.getErrorDetaisForJWTValidation().getSecond());
    }

    @Test
    public void testValidPrivateKeyJWT() throws Exception {
        SignedJWT jwt = AbstractOidcClientAuthenticationFlowTest.createPrivateKeyJWT(this.validClaimsSet(), this.rsaPrivateKey);
        FlowExecutionResult result = this.launchWithJwtAuthentication(jwt, JWSAlgorithm.RS256, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.assertSuccessResponse(result);
    }

    protected JWTClaimsSet claimsSetMissingSub() {
        return new JWTClaimsSet.Builder().issuer(this.clientId).audience(this.jwtAud).expirationTime(Date.from(Instant.now().plusSeconds(600L))).jwtID(this.idGenerator.generateIdentifier()).build();
    }

    protected JWTClaimsSet claimsSetMissingIss() {
        return new JWTClaimsSet.Builder().subject(this.clientId).audience(this.jwtAud).expirationTime(Date.from(Instant.now().plusSeconds(600L))).jwtID(this.idGenerator.generateIdentifier()).build();
    }

    protected JWTClaimsSet claimsSetMissingAud() {
        return new JWTClaimsSet.Builder().subject(this.clientId).issuer(this.clientId).expirationTime(Date.from(Instant.now().plusSeconds(600L))).jwtID(this.idGenerator.generateIdentifier()).build();
    }

    protected JWTClaimsSet claimsSetMissingExp() {
        return new JWTClaimsSet.Builder().subject(this.clientId).issuer(this.clientId).audience(this.jwtAud).jwtID(this.idGenerator.generateIdentifier()).build();
    }

    protected JWTClaimsSet claimsSetExpiredExp() {
        return new JWTClaimsSet.Builder().subject(this.clientId).issuer(this.clientId).audience(this.jwtAud).expirationTime(Date.from(Instant.now().minusSeconds(600L))).jwtID(this.idGenerator.generateIdentifier()).build();
    }

    protected JWTClaimsSet claimsSetIssuedInTheFuture() {
        return new JWTClaimsSet.Builder().subject(this.clientId).issuer(this.clientId).audience(this.jwtAud).expirationTime(Date.from(Instant.now().plusSeconds(600L))).issueTime(Date.from(Instant.now().plusSeconds(600L))).jwtID(this.idGenerator.generateIdentifier()).build();
    }

    protected JWTClaimsSet claimsSetMissingJti() {
        return new JWTClaimsSet.Builder().subject(this.clientId).issuer(this.clientId).audience(this.jwtAud).expirationTime(Date.from(Instant.now().plusSeconds(600L))).build();
    }

    protected JWTClaimsSet validClaimsSet() {
        return new JWTClaimsSet.Builder().subject(this.clientId).issuer(this.clientId).audience(this.jwtAud).expirationTime(Date.from(Instant.now().plusSeconds(600L))).jwtID(this.idGenerator.generateIdentifier()).build();
    }

    protected ClientSecretJWT buildSecretJwtAuth(String secret) throws JOSEException, URISyntaxException {
        return new ClientSecretJWT(new ClientID(this.clientId), new URI(this.jwtAud), JWSAlgorithm.HS256, new Secret(secret));
    }

    protected PrivateKeyJWT buildPrivateKeyJwtAuth() throws JOSEException, URISyntaxException {
        return new PrivateKeyJWT(new ClientID(this.clientId), new URI(this.jwtAud), JWSAlgorithm.RS256, this.rsaPrivateKey, null, null);
    }

    protected void populateClientAssertionParams(Map<String, String> requestParameters, JWTAuthentication clientAuth) {
        requestParameters.put("client_assertion", clientAuth.getClientAssertion().serialize());
        requestParameters.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
    }

    protected abstract FlowExecutionResult launchWithJwtAuthentication(SignedJWT var1, JWSAlgorithm var2, ClientAuthenticationMethod var3) throws Exception;

    protected abstract Pair<String, String> getErrorDetaisForJWTValidation();

    protected abstract void assertSuccessResponse(FlowExecutionResult var1);
}

