/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import java.time.Duration;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.context.OAuth2TokenMgmtResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.RevokeToken;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.testing.BaseTokenClaimsSetTest;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenRevocationConfiguration;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class RevokeTokenTest
extends BaseTokenClaimsSetTest {
    private RevokeToken action;
    private MemoryStorageService storageService;
    private AccessTokenClaimsSet atClaimsSet;
    private RefreshTokenClaimsSet rfClaimsSet;
    private RevocationCache revocationCache;
    private RequestContext src;
    private ProfileRequestContext prc;
    private OAuth2TokenMgmtResponseContext tokenCtx;

    protected void setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod method, String rootTokenId) throws Exception {
        this.setUp(method, rootTokenId, this.exp);
    }

    protected void setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod method, String rootTokenId, Instant exp) throws Exception {
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.initialize();
        this.revocationCache = new RevocationCache();
        this.revocationCache.setEntryExpiration(Duration.ofHours(1L));
        this.revocationCache.setStorage((StorageService)this.storageService);
        this.revocationCache.initialize();
        AuthorizeCodeClaimsSet acClaimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy()).setClientID(this.clientID).setIssuer(this.issuer).setPrincipal(this.userPrincipal).setSubject(this.subject).setIssuedAt(this.iat).setExpiresAt(exp).setAuthenticationTime(this.authTime).setRedirectURI(this.redirectURI).setScope(this.scope).build();
        this.atClaimsSet = (AccessTokenClaimsSet)new AccessTokenClaimsSet.Builder((TokenClaimsSet)acClaimsSet, this.scope, this.dlClaims, this.dlClaimsUI, this.iat, exp).setRootTokenIdentifier(rootTokenId).build();
        this.rfClaimsSet = (RefreshTokenClaimsSet)new RefreshTokenClaimsSet.Builder((TokenClaimsSet)acClaimsSet, this.iat, exp).setRootTokenIdentifier(rootTokenId).build();
        this.action = new RevokeToken();
        this.action.setRevocationCache(this.revocationCache);
        this.action.setRevocationMethodLookupStrategy(prc -> method);
        this.action.setChainRevocationLifetimeLookupStrategy(prc -> Duration.ofHours(1L));
        this.action.initialize();
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.tokenCtx = (OAuth2TokenMgmtResponseContext)this.prc.getOutboundMessageContext().getSubcontext(OAuth2TokenMgmtResponseContext.class, true);
    }

    @AfterMethod
    protected void tearDown() {
        this.action.destroy();
        this.revocationCache.destroy();
        this.storageService.destroy();
    }

    @Test
    public void testChain_NoToken() throws Exception {
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.CHAIN, null);
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
    }

    @Test
    public void testChain_RevokeAccessToken() throws Exception {
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.CHAIN, null);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.atClaimsSet.getID()));
        this.tokenCtx.setTokenClaimsSet(this.atClaimsSet.getClaimsSet());
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.atClaimsSet.getID()));
    }

    @Test
    public void testChain_RevokeRefreshToken() throws Exception {
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.CHAIN, null);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.rfClaimsSet.getID()));
        this.tokenCtx.setTokenClaimsSet(this.rfClaimsSet.getClaimsSet());
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.rfClaimsSet.getID()));
    }

    @Test
    public void testChain_RevokeAccessTokenViaRootToken() throws Exception {
        String rootTokenIdentifier = new SecureRandomIdentifierGenerationStrategy().generateIdentifier();
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.CHAIN, rootTokenIdentifier);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootTokenIdentifier));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.atClaimsSet.getID()));
        this.tokenCtx.setTokenClaimsSet(this.atClaimsSet.getClaimsSet());
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootTokenIdentifier));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.atClaimsSet.getID()));
    }

    @Test
    public void testChain_RevokeRefreshTokenViaRootToken() throws Exception {
        String rootTokenIdentifier = new SecureRandomIdentifierGenerationStrategy().generateIdentifier();
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.CHAIN, rootTokenIdentifier);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootTokenIdentifier));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.rfClaimsSet.getID()));
        this.tokenCtx.setTokenClaimsSet(this.rfClaimsSet.getClaimsSet());
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootTokenIdentifier));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.rfClaimsSet.getID()));
    }

    @Test
    public void testSingleToken_NoToken() throws Exception {
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.TOKEN, null);
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
    }

    @Test
    public void testSingleToken_ExpiredAccessToken() throws Exception {
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.TOKEN, null, Instant.now().minus(Duration.ofMinutes(10L)));
        this.tokenCtx.setTokenClaimsSet(this.atClaimsSet.getClaimsSet());
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.src), (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testSingleToken_ExpiredRefreshToken() throws Exception {
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.TOKEN, null, Instant.now().minus(Duration.ofMinutes(10L)));
        this.tokenCtx.setTokenClaimsSet(this.rfClaimsSet.getClaimsSet());
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.src), (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testSingleToken_RevokeAccessToken() throws Exception {
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.TOKEN, null);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.atClaimsSet.getID()));
        this.tokenCtx.setTokenClaimsSet(this.atClaimsSet.getClaimsSet());
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.atClaimsSet.getID()));
    }

    @Test
    public void testSingleToken_RevokeRefreshToken() throws Exception {
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.TOKEN, null);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaimsSet.getID()));
        this.tokenCtx.setTokenClaimsSet(this.rfClaimsSet.getClaimsSet());
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaimsSet.getID()));
    }

    @Test
    public void testSingleToken_RevokeAccessTokenViaRootToken() throws Exception {
        String rootTokenIdentifier = new SecureRandomIdentifierGenerationStrategy().generateIdentifier();
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.TOKEN, rootTokenIdentifier);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootTokenIdentifier));
        this.tokenCtx.setTokenClaimsSet(this.atClaimsSet.getClaimsSet());
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.atClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootTokenIdentifier));
    }

    @Test
    public void testSingleToken_RevokeRefreshTokenViaRootToken() throws Exception {
        String rootTokenIdentifier = new SecureRandomIdentifierGenerationStrategy().generateIdentifier();
        this.setUp(OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.TOKEN, rootTokenIdentifier);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootTokenIdentifier));
        this.tokenCtx.setTokenClaimsSet(this.rfClaimsSet.getClaimsSet());
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaimsSet.getID()));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootTokenIdentifier));
    }
}

