/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.OIDCAuthenticationRequestDecoder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCAuthenticationRequestDecoderTest {
    private MockHttpServletRequest httpRequest;
    private OIDCAuthenticationRequestDecoder decoder;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod("GET");
        this.decoder = new OIDCAuthenticationRequestDecoder();
        this.decoder.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.decoder.initialize();
    }

    @Test
    public void testRequestDecoding() throws MessageDecodingException {
        this.httpRequest.setQueryString("response_type=code&client_id=s6BhdRkqt3&redirect_uri=https%3A%2F%2Fclient.example.org%2Fcb&scope=openid%20profile&state=af0ifjsldkj&nonce=n-0S6_WzA2Mj");
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertEquals((String)((AuthenticationRequest)messageContext.getMessage()).getResponseType().toString(), (String)ResponseType.Value.CODE.toString());
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testInvalidRequestDecoding() throws MessageDecodingException {
        this.httpRequest.setQueryString("client_id=s6BhdRkqt3&redirect_uri=https%3A%2F%2Fclient.example.org%2Fcb&scope=openid%20profile&state=af0ifjsldkj&nonce=n-0S6_WzA2Mj");
        this.decoder.decode();
    }
}

