/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.ValidateCredentials;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.plugin.oidc.op.authn.impl.JWTCredentialValidator;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.profile.oauth2.config.AbstractOAuth2ClientAuthenticableProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenConfiguration;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.oidc.security.impl.OIDCSignatureValidationParameters;
import net.shibboleth.oidc.security.jwt.claims.impl.AudienceClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.ChainingJWTClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.ExactMatchClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.ExpiryClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.IssuedAtClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.JWTIdentifierClaimsValidator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.BiFunctionSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JWTCredentialValidatorTest
extends BaseAuthenticationContextTest {
    ClientID clientId;
    Secret clientSecret;
    URI endpointUri;
    RSAPrivateKey rsaPrivateKey;
    RSAPublicKey rsaPublicKey;
    private ClaimsValidator claimsValidator;
    private JWTCredentialValidator validator;
    private ValidateCredentials action;

    @BeforeClass
    public void initKeys() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.genKeyPair();
        this.rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        this.rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
    }

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.clientId = new ClientID("mockId");
        this.clientSecret = new Secret("secret1234567890secret1234567890secret1234567890");
        try {
            this.endpointUri = new URI("http://localhost");
        }
        catch (URISyntaxException e) {
            throw new ComponentInitializationException((Exception)e);
        }
        ReplayCache replayCache = new ReplayCache();
        MemoryStorageService storageService = new MemoryStorageService();
        storageService.setId("mockId");
        storageService.initialize();
        replayCache.setStorage((StorageService)storageService);
        this.claimsValidator = this.constructClaimsValidator((HttpServletRequest)this.src.getExternalContext().getNativeRequest(), replayCache);
        OAuth2TokenConfiguration profile = new OAuth2TokenConfiguration();
        profile.setClaimsValidator(this.claimsValidator);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig((ProfileConfiguration)profile);
        this.validator = new JWTCredentialValidator();
        this.validator.setId("test");
        this.validator.setSecurityParametersLookupStrategy((Function)new ChildContextLookup(SecurityParametersContext.class));
        this.validator.initialize();
        this.action = new ValidateCredentials();
        this.action.setValidators(Collections.singletonList(this.validator));
        this.action.initialize();
    }

    protected void completeSetup(TokenRequest request, ClientAuthenticationMethod storedMethod, boolean sameSecret) throws NoSuchAlgorithmException, JOSEException {
        OIDCMetadataContext oidcContext = new OIDCMetadataContext();
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        metadata.setTokenEndpointAuthMethod(storedMethod);
        BasicJWKCredential credential = null;
        OIDCSignatureValidationParameters params = new OIDCSignatureValidationParameters();
        if (storedMethod.equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            RSAKey rsaKey;
            params.setSignatureAlgorithm("RS256");
            credential = new BasicJWKCredential();
            credential.setAlgorithm((Algorithm)JWSAlgorithm.parse((String)"RS256"));
            if (sameSecret) {
                rsaKey = new RSAKey.Builder(this.rsaPublicKey).build();
            } else {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                keyGen.initialize(1024);
                rsaKey = new RSAKey.Builder((RSAPublicKey)keyGen.genKeyPair().getPublic()).build();
            }
            credential.setPublicKey(rsaKey.toPublicKey());
        } else if (storedMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT)) {
            params.setSignatureAlgorithm("HS256");
            credential = new BasicJWKCredential();
            credential.setAlgorithm((Algorithm)JWSAlgorithm.parse((String)"HS256"));
            if (sameSecret) {
                credential.setSecretKey((SecretKey)new SecretKeySpec(this.clientSecret.getValueBytes(), "NONE"));
            } else {
                credential.setSecretKey((SecretKey)new SecretKeySpec("secret1234567890secret1234567890secretWRONG".getBytes(), "NONE"));
            }
        }
        if (credential != null) {
            SecurityParametersContext secCtx = (SecurityParametersContext)this.prc.addSubcontext((BaseContext)new SecurityParametersContext());
            params.getValidationCredentials().add(credential);
            secCtx.setSignatureSigningParameters((SignatureSigningParameters)params);
        }
        OIDCClientInformation clientInformation = new OIDCClientInformation(this.clientId, new Date(), metadata, this.clientSecret);
        oidcContext.setClientInformation(clientInformation);
        this.prc.getInboundMessageContext().addSubcontext((BaseContext)oidcContext);
    }

    protected void initializeTokenRequest(ClientAuthenticationMethod method, SignedJWT jwt, boolean sameSecret) throws JOSEException, NoSuchAlgorithmException {
        Object clientAuth = method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) ? new ClientSecretJWT(jwt) : (method.equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT) ? new PrivateKeyJWT(jwt) : null);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ((OAuth2ClientAuthenticationContext)ac.getSubcontext(OAuth2ClientAuthenticationContext.class, true)).setClientAuthentication((ClientAuthentication)clientAuth);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, true)).setRelyingPartyId(this.clientId.getValue());
        AuthorizationCodeGrant authzGrant = new AuthorizationCodeGrant(new AuthorizationCode(), null);
        this.completeSetup(new TokenRequest(null, (ClientAuthentication)clientAuth, (AuthorizationGrant)authzGrant), method, sameSecret);
    }

    protected ClaimsValidator constructClaimsValidator(HttpServletRequest httpRequest, ReplayCache replayCache) {
        ChainingJWTClaimsValidator claimsValidation = new ChainingJWTClaimsValidator();
        ExpiryClaimsValidator expValidator = new ExpiryClaimsValidator();
        IssuedAtClaimsValidator iatValidator = new IssuedAtClaimsValidator();
        iatValidator.setRequiredRule(false);
        ExactMatchClaimsValidator issValidator = new ExactMatchClaimsValidator();
        issValidator.setClaimName("iss");
        issValidator.setValueToMatchLookupStrategy(BiFunctionSupport.forFunctionOfFirstArg((Function)new RelyingPartyIdLookupFunction()));
        ExactMatchClaimsValidator subValidator = new ExactMatchClaimsValidator();
        subValidator.setClaimName("sub");
        subValidator.setValueToMatchLookupStrategy(BiFunctionSupport.forFunctionOfFirstArg((Function)new RelyingPartyIdLookupFunction()));
        AudienceClaimsValidator audValidator = new AudienceClaimsValidator();
        audValidator.setAudienceLookupStrategy((prc, claims) -> httpRequest.getRequestURL().toString());
        JWTIdentifierClaimsValidator jitValidator = new JWTIdentifierClaimsValidator();
        jitValidator.setReplayCache(replayCache);
        claimsValidation.setClaimValidators(List.of(expValidator, iatValidator, issValidator, subValidator, audValidator, jitValidator));
        return claimsValidation;
    }

    protected void testFailingJwtAuth(ClientAuthenticationMethod method, SignedJWT jwt, boolean replay, boolean sameSecret) throws Exception {
        this.initializeTokenRequest(method, jwt, sameSecret);
        Event event = this.action.execute(this.src);
        if (replay) {
            ActionTestingSupport.assertProceedEvent((Event)event);
            event = this.action.execute(this.src);
        }
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidCredentials");
    }

    protected JWTClaimsSet claimsSetWithIatInTheFuture() {
        return new JWTClaimsSet.Builder().subject(this.clientId.toString()).issuer(this.clientId.toString()).audience(this.endpointUri.toString()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).issueTime(Date.from(Instant.now().plusSeconds(600L))).jwtID("mockId").build();
    }

    protected JWTClaimsSet claimsSetWithExpInThePast() {
        return new JWTClaimsSet.Builder().subject(this.clientId.toString()).issuer(this.clientId.toString()).audience(this.endpointUri.toString()).expirationTime(Date.from(Instant.now().minusSeconds(600L))).issueTime(Date.from(Instant.now())).jwtID("mockId").build();
    }

    protected JWTClaimsSet claimsSetWithoutJit() {
        return new JWTClaimsSet.Builder().subject(this.clientId.toString()).issuer(this.clientId.toString()).audience(this.endpointUri.toString()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).issueTime(Date.from(Instant.now())).build();
    }

    protected JWTClaimsSet validClaimsSet() {
        return new JWTClaimsSet.Builder().subject(this.clientId.toString()).issuer(this.clientId.toString()).audience(this.endpointUri.toString()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).issueTime(Date.from(Instant.now())).jwtID("mockId").build();
    }

    protected SignedJWT createSecretJWT(JWTClaimsSet claimsSet) throws JOSEException {
        return this.createSecretJWT(claimsSet, this.clientSecret.getValue());
    }

    protected SignedJWT createSecretJWT(JWTClaimsSet claimsSet, String clientSecret) throws JOSEException {
        SignedJWT jwt = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet);
        MACSigner signer = new MACSigner(clientSecret);
        jwt.sign((JWSSigner)signer);
        return jwt;
    }

    protected SignedJWT createPrivateKeyJWT(JWTClaimsSet claimsSet) throws JOSEException {
        SignedJWT jwt = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet);
        RSASSASigner signer = new RSASSASigner((PrivateKey)this.rsaPrivateKey);
        jwt.sign((JWSSigner)signer);
        return jwt;
    }

    @Test
    public void testNoClaimsValidator() throws Exception {
        ((AbstractOAuth2ClientAuthenticableProfileConfiguration)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig()).setClaimsValidator(null);
        this.testFailingJwtAuth(ClientAuthenticationMethod.CLIENT_SECRET_JWT, this.createSecretJWT(this.validClaimsSet()), false, true);
    }

    @Test
    public void testSecretJwt() throws JOSEException, NoSuchAlgorithmException {
        this.initializeTokenRequest(ClientAuthenticationMethod.CLIENT_SECRET_JWT, this.createSecretJWT(this.validClaimsSet()), true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        Assert.assertNotNull((Object)ac.getAuthenticationResult());
        Assert.assertEquals((String)ac.getAuthenticationResult().getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)this.clientId.getValue());
    }

    @Test
    public void testPrivateKeyJwt() throws JOSEException, NoSuchAlgorithmException {
        this.initializeTokenRequest(ClientAuthenticationMethod.PRIVATE_KEY_JWT, this.createPrivateKeyJWT(this.validClaimsSet()), true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        Assert.assertNotNull((Object)ac.getAuthenticationResult());
        Assert.assertEquals((String)ac.getAuthenticationResult().getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)this.clientId.getValue());
    }

    @Test
    public void testInvalidSecretJwt_signature() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.CLIENT_SECRET_JWT, this.createSecretJWT(this.validClaimsSet()), false, false);
    }

    @Test
    public void testInvalidSecretJwt_iatInTheFuture() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.CLIENT_SECRET_JWT, this.createSecretJWT(this.claimsSetWithIatInTheFuture()), false, true);
    }

    @Test
    public void testInvalidSecretJwt_expInThePast() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.CLIENT_SECRET_JWT, this.createSecretJWT(this.claimsSetWithExpInThePast()), false, true);
    }

    @Test
    public void testInvalidSecretJwt_withoutJit() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.CLIENT_SECRET_JWT, this.createSecretJWT(this.claimsSetWithoutJit()), false, true);
    }

    @Test
    public void testInvalidSecretJwt_jitReplayDetected() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.CLIENT_SECRET_JWT, this.createSecretJWT(this.validClaimsSet()), true, true);
    }

    @Test
    public void testInvalidPrivateKeyJwt_signature() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.PRIVATE_KEY_JWT, this.createPrivateKeyJWT(this.validClaimsSet()), false, false);
    }

    @Test
    public void testInvalidPrivateKeyJwt_iatInTheFuture() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.PRIVATE_KEY_JWT, this.createPrivateKeyJWT(this.claimsSetWithIatInTheFuture()), false, true);
    }

    @Test
    public void testInvalidPrivateKeyJwt_expInThePast() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.PRIVATE_KEY_JWT, this.createPrivateKeyJWT(this.claimsSetWithExpInThePast()), false, true);
    }

    @Test
    public void testInvalidPrivateKeyJwt_withoutJit() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.PRIVATE_KEY_JWT, this.createPrivateKeyJWT(this.claimsSetWithoutJit()), false, true);
    }

    @Test
    public void testInvalidPrivateKeyJwt_jitReplayDetected() throws Exception {
        this.testFailingJwtAuth(ClientAuthenticationMethod.PRIVATE_KEY_JWT, this.createPrivateKeyJWT(this.validClaimsSet()), true, true);
    }
}

