/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;

import com.nimbusds.openid.connect.sdk.UserInfoRequest;

import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCRequestAction;

/**
 * Abstract class for actions performing actions on {@link UserInfoRequest} found via
 * {@link ProfileRequestContext#getInboundMessageContext()} and {@link MessageContext#getMessage()}.
 */
public abstract class AbstractOIDCUserInfoRequestAction extends AbstractOIDCRequestAction<UserInfoRequest> {

    /**
     * Returns OIDC user info request.
     * 
     * @return request
     */
    public UserInfoRequest getUserInfoRequest() {
        return getRequest();
    }

}
