/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;

public class RootTokenIdRevocationValidator
extends AbstractClaimsValidator {
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @NonnullAfterInit
    @NotEmpty
    private String context;

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    public void setContext(@Nonnull @NotEmpty String ctx) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.context = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)ctx), (String)"Context cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.revocationCache == null) {
            throw new ComponentInitializationException("RevocationCache cannot be null");
        }
        if (this.context == null) {
            throw new ComponentInitializationException("Context cannot be null");
        }
    }

    protected void doValidate(@Nonnull JWTClaimsSet claims, @Nullable ProfileRequestContext profileRequestContext) throws JWTValidationException {
        String rootJti = (String)claims.getClaim("root_jti");
        String rootJtiToUse = StringSupport.trimOrNull((String)rootJti) == null ? claims.getJWTID() : rootJti;
        if (StringSupport.trimOrNull((String)rootJtiToUse) == null) {
            throw new JWTValidationException("Claims set is missing required JWT identifier claim");
        }
        if (this.revocationCache.isRevoked(this.context, rootJtiToUse)) {
            throw new JWTValidationException("Claims set with root ID '" + rootJtiToUse + "' has been revoked");
        }
    }
}

