/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.function.SpringFlowScopeLookupFunction;
import net.shibboleth.oidc.metadata.criterion.ResourceLocationCriterion;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetadataPolicyCriteriaLookupFunction
implements Function<ProfileRequestContext, CriteriaSet> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultMetadataPolicyCriteriaLookupFunction.class);

    @Override
    @Nullable
    public CriteriaSet apply(@Nonnull ProfileRequestContext profileRequestContext) {
        String location = new SpringFlowScopeLookupFunction("policyLocation").apply(profileRequestContext);
        if (StringSupport.trimOrNull((String)location) == null) {
            this.log.debug("Could not find a policy location for building the criteria set, returning null");
            return null;
        }
        this.log.trace("Found a location {} to be included in the criteria set", (Object)location);
        ResourceLocationCriterion criterion = new ResourceLocationCriterion(location);
        return new CriteriaSet(new Criterion[]{criterion});
    }
}

