/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultTokenRevocationLifetimeLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.oidc.profile.config.logic.EnforceRefreshTokenRotationPredicate;
import net.shibboleth.oidc.profile.config.navigate.RefreshTokenClaimsSetManipulationStrategyLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.RefreshTokenLifetimeLookupFunction;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetRefreshTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetRefreshTokenToResponseContext.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @Nonnull
    private Function<ProfileRequestContext, Duration> refreshTokenLifetimeLookupStrategy = new RefreshTokenLifetimeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> tokenClaimsSetManipulationStrategyLookupStrategy;
    @Nullable
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> enforceRefreshTokenRotationCondition;
    @Nonnull
    private Function<JWTClaimsSet, Duration> tokenRevocationLifetimeLookupStrategy;
    @Nullable
    private TokenClaimsSet tokenClaimsSet;
    @Nullable
    private Duration refreshTokenLifetime;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;

    public SetRefreshTokenToResponseContext(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
        this.tokenClaimsSetManipulationStrategyLookupStrategy = new RefreshTokenClaimsSetManipulationStrategyLookupFunction();
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
        this.enforceRefreshTokenRotationCondition = new EnforceRefreshTokenRotationPredicate();
        this.tokenRevocationLifetimeLookupStrategy = new DefaultTokenRevocationLifetimeLookupStrategy();
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    public void setRefreshTokenLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.refreshTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Refresh token lifetime lookup strategy cannot be null");
    }

    public void setTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Manipulation strategy lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier generation strategy cannot be null");
    }

    public void setEnforceRefreshTokenRotationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.enforceRefreshTokenRotationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setTokenRevocationLifetimeLookupStrategy(@Nullable Function<JWTClaimsSet, Duration> strategy) {
        this.tokenRevocationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.revocationCache == null) {
            throw new ComponentInitializationException("RevocationCache cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getOidcResponseContext().getScope() == null || !this.getOidcResponseContext().getScope().contains((Object)OIDCScopeValue.OFFLINE_ACCESS)) {
            this.log.debug("{} No offline_access scope, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.refreshTokenLifetime = this.refreshTokenLifetimeLookupStrategy.apply(profileRequestContext);
        if (this.refreshTokenLifetime == null) {
            this.log.warn("{} No lifetime supplied for refresh token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.tokenClaimsSet = this.getOidcResponseContext().getAuthorizationGrantClaimsSet();
        if (this.tokenClaimsSet == null || !(this.tokenClaimsSet instanceof RefreshTokenClaimsSet) && !(this.tokenClaimsSet instanceof AuthorizeCodeClaimsSet)) {
            this.log.error("{} No token to base refresh on", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.manipulationStrategy = this.tokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.error("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Instant dateExp = Instant.now().plus(this.refreshTokenLifetime);
        String rootTokenId = StringSupport.trimOrNull((String)this.tokenClaimsSet.getRootTokenIdentifier()) == null ? this.tokenClaimsSet.getID() : this.tokenClaimsSet.getRootTokenIdentifier();
        RefreshTokenClaimsSet claimsSet = (RefreshTokenClaimsSet)new RefreshTokenClaimsSet.Builder(this.tokenClaimsSet, Instant.now(), dateExp).setJWTID(this.idGenerator).setRootTokenIdentifier(rootTokenId).build();
        if (this.manipulationStrategy != null) {
            this.log.debug("{} Manipulation strategy has been set, applying it to the claims set {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, claimsSet.getClaimsSet().toJSONObject());
            if (result == null) {
                this.log.debug("{} Manipulation strategy returned null, leaving token claims set untouched.", (Object)this.getLogPrefix());
            } else {
                this.log.debug("{} Applying the manipulated claims into the token claims set", (Object)this.getLogPrefix());
                try {
                    claimsSet.setClaimsSet(JWTClaimsSet.parse(result));
                }
                catch (ParseException e) {
                    this.log.error("{} The resulted claims set could not be transformed into ", (Object)this.getLogPrefix(), (Object)e);
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                    return;
                }
            }
        } else {
            this.log.debug("{} No manipulation strategy configured", (Object)this.getLogPrefix());
        }
        try {
            this.getOidcResponseContext().setRefreshToken(claimsSet.serialize(this.dataSealer));
            this.log.debug("{} Setting refresh token {} as {} to response context ", new Object[]{this.getLogPrefix(), claimsSet.serialize(), this.getOidcResponseContext().getRefreshToken()});
        }
        catch (DataSealerException e) {
            this.log.error("{} Refresh Token generation failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
        }
        if (this.enforceRefreshTokenRotationCondition.test(profileRequestContext) && this.tokenClaimsSet instanceof RefreshTokenClaimsSet) {
            String jti = this.tokenClaimsSet.getID();
            Duration lifetime = this.tokenRevocationLifetimeLookupStrategy.apply(this.tokenClaimsSet.getClaimsSet());
            if (lifetime == null || Duration.ZERO.equals(lifetime)) {
                this.log.error("{} Unable to fetch lifetime for the single token revocation", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
            this.log.debug("{} Revoking the refresh token {} used for issuing the new one", (Object)this.getLogPrefix(), (Object)jti);
            if (!this.revocationCache.revoke(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, jti, lifetime)) {
                this.log.error("{} Unable to store revocation into the revocation cache", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
        }
    }
}

