/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.oidc.profile.config.navigate.IDTokenManipulationStrategyLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManipulateClaimsForIDToken
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ManipulateClaimsForIDToken.class);
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> idTokenManipulationStrategyLookupStrategy = new IDTokenManipulationStrategyLookupFunction();
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    private IDTokenClaimsSet idToken;

    public void setIDTokenManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idTokenManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IDToken manipulation strategy lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.idToken = this.getOidcResponseContext().getIDToken();
        if (this.idToken == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.manipulationStrategy = this.idTokenManipulationStrategyLookupStrategy.apply(profileRequestContext);
        if (this.manipulationStrategy == null) {
            this.log.debug("{} No manipulation strategy resolved, nothing to do.", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        IDTokenClaimsSet newIdToken;
        Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, (Map<String, Object>)this.idToken.toJSONObject());
        if (result == null) {
            this.log.debug("{} Manipulation strategy retruned null, leaving id_token claims untouched.", (Object)this.getLogPrefix());
            return;
        }
        this.log.debug("{} Applying the manipulated claims into the id_token", (Object)this.getLogPrefix());
        try {
            newIdToken = new IDTokenClaimsSet(JWTClaimsSet.parse(result));
        }
        catch (ParseException | java.text.ParseException e) {
            this.log.error("{} The resulted claims set could not be transformed into id_token", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return;
        }
        this.log.debug("{} Replacing the id_token with the manipulated contents", (Object)this.getLogPrefix());
        this.getOidcResponseContext().setIDToken(newIdToken);
    }
}

