/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationMetadataPolicyContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCClientRegistrationTokenMetadataPolicyLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultMetadataPolicyMergingStrategy;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.DefaultMetadataPolicyValidator;
import net.shibboleth.oidc.profile.config.navigate.RegistrationMetadataPolicyLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeRegistrationMetadataPolicyContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeRegistrationMetadataPolicyContext.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Map<String, MetadataPolicy>> profileMetadataPolicyLookupStrategy = new RegistrationMetadataPolicyLookupFunction();
    @NonnullAfterInit
    private Function<ProfileRequestContext, Map<String, MetadataPolicy>> tokenMetadataPolicyLookupStrategy = new DefaultOIDCClientRegistrationTokenMetadataPolicyLookupFunction();
    @NonnullAfterInit
    private Function<ProfileRequestContext, OIDCClientRegistrationMetadataPolicyContext> registrationPolicyContextCreationStrategy = new ChildContextLookup(OIDCClientRegistrationMetadataPolicyContext.class, true).compose((Function)new InboundMessageContextLookup());
    @NonnullAfterInit
    private BiFunction<Map<String, MetadataPolicy>, Map<String, MetadataPolicy>, Pair<Map<String, MetadataPolicy>, Boolean>> metadataPolicyMergingStrategy = new DefaultMetadataPolicyMergingStrategy();
    @NonnullAfterInit
    private Predicate<Map<String, MetadataPolicy>> metadataPolicyValidationStrategy = new DefaultMetadataPolicyValidator();
    private OIDCClientRegistrationMetadataPolicyContext metadataPolicyContext;

    public void setProfileMetadataPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MetadataPolicy>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileMetadataPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Profile metadata policy lookup strategy cannot be null");
    }

    public void setTokenMetadataPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MetadataPolicy>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenMetadataPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Token metadata policy lookup strategy cannot be null");
    }

    public void setRegistrationPolicyContextCreationStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationMetadataPolicyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.registrationPolicyContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationMetadataPolicyContext creation strategy cannot be null");
    }

    public void setMetadataPolicyMergingStrategy(@Nonnull BiFunction<Map<String, MetadataPolicy>, Map<String, MetadataPolicy>, Pair<Map<String, MetadataPolicy>, Boolean>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataPolicyMergingStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Metadata policy merging strategy cannot be null");
    }

    public void setMetadataPolicyValidationStrategy(@Nonnull Predicate<Map<String, MetadataPolicy>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataPolicyValidationStrategy = (Predicate)Constraint.isNotNull(strategy, (String)"Metadata policy validation strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.metadataPolicyContext = this.registrationPolicyContextCreationStrategy.apply(profileRequestContext);
        if (this.metadataPolicyContext == null) {
            this.log.error("{} Registration metadata policy context could not be created, invalid profile context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Map<String, MetadataPolicy> profileMetadataPolicy = this.profileMetadataPolicyLookupStrategy.apply(profileRequestContext);
        Map<String, MetadataPolicy> tokenMetadataPolicy = this.tokenMetadataPolicyLookupStrategy.apply(profileRequestContext);
        if (!this.metadataPolicyValidationStrategy.test(tokenMetadataPolicy)) {
            this.log.warn("{} Metadata policy in token is invalid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Pair<Map<String, MetadataPolicy>, Boolean> mergedResult = this.metadataPolicyMergingStrategy.apply(profileMetadataPolicy, tokenMetadataPolicy);
        if (!((Boolean)mergedResult.getSecond()).booleanValue()) {
            this.log.warn("{} Metadata policies from profile and token could not be merged", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Map mergedPolicy = (Map)mergedResult.getFirst();
        if (!this.metadataPolicyValidationStrategy.test(mergedPolicy)) {
            this.log.warn("{} Merged metadata policy is invalid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        this.metadataPolicyContext.setMetadataPolicy(mergedPolicy);
    }
}

