/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.messaging.JSONSuccessResponse;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.profile.config.OIDCSecurityConfiguration;
import net.shibboleth.oidc.security.impl.CredentialConversionUtil;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormOutboundKeySetResponseMessage
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormOutboundKeySetResponseMessage.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    private OIDCSecurityConfiguration secConfiguration;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (rpCtx.getProfileConfig() == null) {
            this.log.debug("{} No profile configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        SecurityConfiguration securityConfig = rpCtx.getProfileConfig().getSecurityConfiguration(profileRequestContext);
        if (!(securityConfig instanceof OIDCSecurityConfiguration)) {
            this.log.debug("{} No security configuration associated with the profile configuration of the profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        this.secConfiguration = (OIDCSecurityConfiguration)securityConfig;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EncryptionConfiguration encryptionConfig;
        ArrayList<JWK> publishList = new ArrayList<JWK>();
        SignatureSigningConfiguration signingConfig = this.secConfiguration.getSignatureSigningConfiguration();
        if (signingConfig != null) {
            this.convertAndPublishToList(signingConfig.getSigningCredentials(), publishList);
        }
        if ((encryptionConfig = this.secConfiguration.getRequestObjectDecryptionConfiguration()) != null) {
            this.convertAndPublishToList(encryptionConfig.getKeyTransportEncryptionCredentials(), publishList);
        }
        JWKSet keySet = new JWKSet(publishList);
        JSONObject keySetJson = new JSONObject(keySet.toJSONObject());
        profileRequestContext.getOutboundMessageContext().setMessage((Object)new JSONSuccessResponse(keySetJson));
    }

    protected void convertAndPublishToList(List<Credential> credentials, List<JWK> publishList) {
        if (credentials != null) {
            for (Credential credential : credentials) {
                JWK jwk = CredentialConversionUtil.credentialToKey((Credential)credential);
                if (jwk == null) continue;
                publishList.add(jwk);
            }
        }
    }
}

