/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestResponseModeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestStateLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.oidc.profile.config.logic.IncludeIssuerInAuthenticationResponsePredicate;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormOutboundAuthenticationResponseMessage
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormOutboundAuthenticationResponseMessage.class);
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new ResponderIdLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> includeIssuerInResponsePredicate = new IncludeIssuerInAuthenticationResponsePredicate();
    private Issuer issuer;

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    public void setIncludeIssuerInResponsePredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.includeIssuerInResponsePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Include issuer in response predicate cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.includeIssuerInResponsePredicate.test(profileRequestContext)) {
            String issValue = this.issuerLookupStrategy.apply(profileRequestContext);
            if (StringSupport.trimOrNull((String)issValue) == null) {
                this.log.error("{} Could not resolve value for issuer even though it's required", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
                return false;
            }
            this.issuer = new Issuer(issValue);
        } else {
            this.issuer = null;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.getOidcResponseContext().getRedirectURI() == null) {
            this.log.error("{} redirect uri must be validated to form response", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        AuthenticationSuccessResponse resp = new AuthenticationSuccessResponse(this.getOidcResponseContext().getRedirectURI(), this.getOidcResponseContext().getAuthorizationCode(), this.getOidcResponseContext().getProcessedToken(), this.getOidcResponseContext().getAccessToken(), (State)new DefaultRequestStateLookupFunction().apply(profileRequestContext), null, this.issuer, (ResponseMode)new DefaultRequestResponseModeLookupFunction().apply(profileRequestContext));
        profileRequestContext.getOutboundMessageContext().setMessage((Object)resp);
    }
}

