/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.Nonce;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestNonceLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNonceToIDToken
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddNonceToIDToken.class);
    @Nonnull
    private Function<ProfileRequestContext, Nonce> requestNonceLookupStrategy = new DefaultRequestNonceLookupFunction();

    public void setRequestNonceLookupStrategy(@Nonnull Function<ProfileRequestContext, Nonce> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requestNonceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RequestNonceLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.getOidcResponseContext().getIDToken() == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        Nonce nonce = this.requestNonceLookupStrategy.apply(profileRequestContext);
        if (nonce != null) {
            this.log.debug("{} Setting nonce to id token", (Object)this.getLogPrefix());
            this.getOidcResponseContext().getIDToken().setNonce(nonce);
            this.log.debug("{} Updated token {}", (Object)this.getLogPrefix(), (Object)this.getOidcResponseContext().getIDToken().toJSONObject().toJSONString());
        }
    }
}

