/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCSigningResponseAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAuthorizationCodeHashToIDToken
extends AbstractOIDCSigningResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAuthorizationCodeHashToIDToken.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> codeHashCalculationStrategy;

    public void setCodeHashCalculationStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.codeHashCalculationStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authorization code hash calculation strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.codeHashCalculationStrategy == null) {
            throw new ComponentInitializationException("Authorization code hash calculation strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.getOidcResponseContext().getIDToken() == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        String hashValue = this.codeHashCalculationStrategy.apply(profileRequestContext);
        if (StringSupport.trimOrNull((String)hashValue) == null) {
            this.log.error("{} Could not produce the authorization code hash value", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return;
        }
        this.log.debug("{} Setting authz code hash to id token", (Object)this.getLogPrefix());
        this.getOidcResponseContext().getIDToken().setClaim("c_hash", (Object)hashValue);
        this.log.debug("{} Updated token {}", (Object)this.getLogPrefix(), (Object)this.getOidcResponseContext().getIDToken().toJSONObject().toJSONString());
    }
}

