/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.context.OAuth2TokenMgmtResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCRequestAction;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.profile.config.navigate.IssuedClaimsValidatorLookupFunction;
import net.shibboleth.oidc.security.impl.JWTSignatureValidationUtil;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessTokenAction<T>
extends AbstractOIDCRequestAction<T> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractProcessTokenAction.class);
    @Nullable
    private DataSealer dataSealer;
    @Nonnull
    private Function<ProfileRequestContext, ClaimsValidator> claimsValidatorLookupStrategy = new IssuedClaimsValidatorLookupFunction();
    @Nullable
    private ClaimsValidator claimsValidator;
    @Nullable
    private CredentialResolver credentialResolver;
    @Nullable
    private SignedJWT signedJWT;

    public void setDataSealer(@Nullable DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = sealer;
    }

    public void setClaimsValidatorLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.claimsValidatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setCredentialResolver(@Nullable CredentialResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.credentialResolver = resolver;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.claimsValidator = this.claimsValidatorLookupStrategy.apply(profileRequestContext);
        if (this.claimsValidator == null) {
            this.log.error("{} Unable to obtain ClaimsValidator to apply", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((Object)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JWTClaimsSet tokenClaimsSet;
        Token token = this.getToken(profileRequestContext);
        if (token == null) {
            this.log.error("{} Token missing from request", (Object)this.getLogPrefix());
            return;
        }
        this.log.debug("{} Token to introspect: {}", (Object)this.getLogPrefix(), (Object)token.getValue());
        if (token instanceof AccessToken) {
            tokenClaimsSet = this.parseAccessToken(token);
        } else if (token instanceof RefreshToken) {
            tokenClaimsSet = this.parseRefreshToken(token);
        } else {
            tokenClaimsSet = this.parseAccessToken(token);
            if (tokenClaimsSet == null) {
                tokenClaimsSet = this.parseRefreshToken(token);
            }
        }
        if (tokenClaimsSet == null) {
            this.log.warn("{} Unable to parse/decode token for introspection", (Object)this.getLogPrefix());
            return;
        }
        if (this.signedJWT != null) {
            JOSEObjectType typ = this.signedJWT.getHeader().getType();
            if (typ == null || !"at+jwt".equals(typ.getType())) {
                this.log.warn("{} Missing or invalid token type: {}", (Object)this.getLogPrefix(), (Object)(typ != null ? typ.getType() : "null"));
                return;
            }
            if (this.credentialResolver == null) {
                this.log.error("{} No CredentialResolver available, can't verify JWT signature", (Object)this.getLogPrefix());
                return;
            }
            this.log.debug("{} Checking JWT signature", (Object)this.getLogPrefix());
            ArrayList credList = new ArrayList();
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new UsageCriterion(UsageType.SIGNING)});
            try {
                Iterable creds = this.credentialResolver.resolve((Object)criteriaSet);
                if (creds != null) {
                    creds.forEach(credList::add);
                }
            }
            catch (ResolverException e) {
                this.log.error("{} Failure resolving signing credentials, can't verify JWT signature", (Object)this.getLogPrefix(), (Object)e);
                return;
            }
            String errorEventId = JWTSignatureValidationUtil.validateSignatureEx(credList, (SignedJWT)this.signedJWT, (String)"InvalidGrant");
            if (errorEventId != null) {
                this.log.warn("{} Signature on token ID '{}' invalid", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.getJWTID());
                return;
            }
        }
        this.log.debug("{} Validating parsed/decoded claims set: {}", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.toString());
        try {
            this.claimsValidator.validate(tokenClaimsSet, profileRequestContext);
        }
        catch (JWTValidationException e) {
            this.log.warn("{} Claims validation failed, token is invalid: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            return;
        }
        ((OAuth2TokenMgmtResponseContext)profileRequestContext.getOutboundMessageContext().getSubcontext(OAuth2TokenMgmtResponseContext.class)).setTokenClaimsSet(tokenClaimsSet);
    }

    @Nullable
    protected JWTClaimsSet parseAccessToken(@Nonnull @NotEmpty Token token) {
        try {
            this.signedJWT = SignedJWT.parse((String)token.getValue());
            return this.signedJWT.getJWTClaimsSet();
        }
        catch (ParseException parseException) {
            try {
                return AccessTokenClaimsSet.parse((String)token.getValue(), (DataSealer)this.dataSealer).getClaimsSet();
            }
            catch (ParseException | DataSealerException throwable) {
                return null;
            }
        }
    }

    @Nullable
    protected JWTClaimsSet parseRefreshToken(@Nonnull @NotEmpty Token token) {
        try {
            return RefreshTokenClaimsSet.parse((String)token.getValue(), (DataSealer)this.dataSealer).getClaimsSet();
        }
        catch (ParseException | DataSealerException throwable) {
            return null;
        }
    }

    @Nullable
    protected abstract Token getToken(@Nonnull ProfileRequestContext var1);
}

