/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.AESEncrypter;
import com.nimbusds.jose.crypto.ECDHEncrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jwt.EncryptedJWT;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.security.impl.CredentialConversionUtil;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEncryptTokenAction
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractEncryptTokenAction.class);
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy = new ChildContextLookup(EncryptionContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nullable
    private EncryptionParameters params;

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        EncryptionContext encryptCtx = this.encryptionContextLookupStrategy.apply(profileRequestContext);
        if (encryptCtx == null) {
            this.log.error("{} No EncryptionContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.params = encryptCtx.getAssertionEncryptionParameters();
        if (this.params == null) {
            this.log.debug("{} No Encryption parameters, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Payload payload = this.getPayload(profileRequestContext);
        if (payload == null) {
            this.log.debug("{} No plain text source provided to encrypt", (Object)this.getLogPrefix());
            return;
        }
        JWEAlgorithm encAlg = JWEAlgorithm.parse((String)this.params.getKeyTransportEncryptionAlgorithm());
        Credential credential = this.params.getKeyTransportEncryptionCredential();
        EncryptionMethod encEnc = EncryptionMethod.parse((String)this.params.getDataEncryptionAlgorithm());
        String kid = CredentialConversionUtil.resolveKid((Credential)credential);
        this.log.debug("{} Encrypting with kid {} and params alg: {} enc: {}", new Object[]{this.getLogPrefix(), kid, encAlg.getName(), encEnc.getName()});
        JWEObject jweObject = new JWEObject(new JWEHeader.Builder(encAlg, encEnc).contentType("JWT").keyID(kid).build(), payload);
        try {
            if (JWEAlgorithm.Family.RSA.contains((Object)encAlg)) {
                jweObject.encrypt((JWEEncrypter)new RSAEncrypter((RSAPublicKey)credential.getPublicKey()));
            } else if (JWEAlgorithm.Family.ECDH_ES.contains((Object)encAlg)) {
                jweObject.encrypt((JWEEncrypter)new ECDHEncrypter((ECPublicKey)credential.getPublicKey()));
            } else if (JWEAlgorithm.Family.SYMMETRIC.contains((Object)encAlg)) {
                jweObject.encrypt((JWEEncrypter)new AESEncrypter(credential.getSecretKey()));
            } else {
                this.log.error("{} Unsupported algorithm {}", (Object)this.getLogPrefix(), (Object)encAlg.getName());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
            }
            this.setProcessedToken(profileRequestContext, EncryptedJWT.parse((String)jweObject.serialize()));
        }
        catch (JOSEException | ParseException e) {
            this.log.error("{} Encryption failed {}", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
        }
    }

    @Nonnull
    protected abstract Payload getPayload(@Nonnull ProfileRequestContext var1);

    protected abstract void setProcessedToken(@Nonnull ProfileRequestContext var1, @Nonnull EncryptedJWT var2);
}

