/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultClientIDLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.AbstractSAMLEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetEntityIdToSAMLPeerEntityContext
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetEntityIdToSAMLPeerEntityContext.class);
    @Nonnull
    private Function<MessageContext, ClientID> clientIDLookupStrategy = new DefaultClientIDLookupFunction();
    @Nonnull
    private Class<? extends AbstractSAMLEntityContext> entityContextClass = SAMLPeerEntityContext.class;

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy lookup strategy cannot be null");
    }

    public void setEntityContextClass(@Nonnull Class<? extends AbstractSAMLEntityContext> clazz) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.entityContextClass = (Class)Constraint.isNotNull(clazz, (String)"SAML entity context class may not be null");
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        AbstractSAMLEntityContext entityCtx = (AbstractSAMLEntityContext)messageContext.getSubcontext(this.entityContextClass);
        if (entityCtx == null) {
            throw new MessageHandlerException("Unable to locate subcontext of type " + this.entityContextClass);
        }
        ClientID clientID = this.clientIDLookupStrategy.apply(messageContext);
        if (clientID != null) {
            this.log.debug("{} Set clientID '{}' to the peer entity context", (Object)this.getLogPrefix(), (Object)clientID.getValue());
            entityCtx.setEntityId(clientID.getValue());
        } else {
            this.log.debug("{} No clientID could be resolved, nothing to do", (Object)this.getLogPrefix());
        }
    }
}

