/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractUsernamePasswordCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class OIDCClientInfoCredentialValidator
extends AbstractUsernamePasswordCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCClientInfoCredentialValidator.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new ChildContextLookup(OIDCMetadataContext.class).compose((Function)new InboundMessageContextLookup());
    @NonnullAfterInit
    private StringDigester digester;
    @Nullable
    private OIDCClientInformation clientInformation = null;

    public void setOidcMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadataContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            this.digester = new StringDigester("SHA-256", StringDigester.OutputFormat.BASE64);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ComponentInitializationException("Error creating digester", (Exception)e);
        }
    }

    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        OIDCMetadataContext oidcMetadataContext = this.oidcMetadataContextLookupStrategy.apply(profileRequestContext);
        if (oidcMetadataContext != null) {
            this.clientInformation = oidcMetadataContext.getClientInformation();
        }
        if (this.clientInformation == null || this.clientInformation.getOIDCMetadata() == null) {
            this.log.debug("{} OIDC client metadata is missing", (Object)this.getLogPrefix());
            return null;
        }
        ClientMetadata clientMetadata = this.clientInformation.getMetadata();
        if (ClientAuthenticationMethod.NONE.equals((Object)clientMetadata.getTokenEndpointAuthMethod())) {
            this.log.debug("{} OIDC client metadata contains 'none' type for endpoint authentication");
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new UsernamePrincipal(this.applyTransforms(this.clientInformation.getID().getValue())));
            return super.populateSubject(subject);
        }
        if (this.clientInformation.getSecret() == null) {
            this.log.debug("{} OIDC client metadata for '{}' missing client secret", (Object)this.getLogPrefix(), (Object)this.clientInformation.getID());
            return null;
        }
        return super.doValidate(profileRequestContext, authenticationContext, warningHandler, errorHandler);
    }

    @Nullable
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull UsernamePasswordContext usernamePasswordContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        String username = usernamePasswordContext.getTransformedUsername();
        this.log.debug("{} Attempting to authenticate effective client ID '{}' ", (Object)this.getLogPrefix(), (Object)username);
        Secret secret = this.clientInformation.getSecret();
        if (secret.getValue().startsWith("{SHA2}")) {
            if (secret.getValue().substring(6).equals(this.digester.apply(usernamePasswordContext.getPassword()))) {
                this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)username);
                return this.populateSubject(new Subject(), usernamePasswordContext);
            }
        } else if (this.clientInformation.getSecret().getValue().equals(usernamePasswordContext.getPassword())) {
            this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)username);
            return this.populateSubject(new Subject(), usernamePasswordContext);
        }
        this.log.info("{} Login by '{}' failed", (Object)this.getLogPrefix(), (Object)username);
        LoginException e = new LoginException("InvalidCredentials");
        if (errorHandler != null) {
            errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
        }
        throw e;
    }
}

