/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.audit.impl;

import com.nimbusds.oauth2.sdk.TokenRevocationRequest;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class RevokedTokenAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, TokenRevocationRequest> requestLookupStrategy;

    public RevokedTokenAuditExtractor(@Nonnull Function<ProfileRequestContext, TokenRevocationRequest> strategy) {
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TokenRevocationRequest lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        TokenRevocationRequest request = this.requestLookupStrategy.apply(input);
        if (request != null && request.getToken() != null) {
            return request.getToken().getValue();
        }
        return null;
    }
}

