/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.audit.impl;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultResponseClaimsSetLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class IdTokenClaimsAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Function<ProfileRequestContext, ClaimsSet> idTokenClaimsLookupStrategy = new DefaultResponseClaimsSetLookupFunction();
    @Nonnull
    @NotEmpty
    private final String key;

    public IdTokenClaimsAuditExtractor(@Nonnull @NotEmpty String claim) {
        this.key = Constraint.isNotEmpty((String)claim, (String)"The claim cannot be empty");
    }

    public void setIdTokenClaimsLookupStrategy(Function<ProfileRequestContext, ClaimsSet> strategy) {
        this.idTokenClaimsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdTokenClaimsStrategy lookup strategy cannot be null");
    }

    @Override
    public String apply(@Nonnull ProfileRequestContext input) {
        ClaimsSet claims = this.idTokenClaimsLookupStrategy.apply(input);
        if (claims != null) {
            return claims.toJSONObject().getAsString(this.key);
        }
        return null;
    }
}

