/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.ValidateAccessToken;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.AudienceClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.ChainingJWTClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.ExpiryClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.NotBeforeClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.RequiredClaimsValidator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.BiFunctionSupport;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateAccessTokenTest
extends BaseOIDCResponseActionTest {
    private ValidateAccessToken action;

    @BeforeMethod
    private void init() throws ComponentInitializationException, NoSuchAlgorithmException {
        this.action = new ValidateAccessToken();
        this.action.setClaimsValidatorLookupStrategy((Function)new ClaimsValidatorLookup());
        this.action.initialize();
    }

    @Test
    public void testSuccess() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, DataSealerException {
        TokenClaimsSet claims = new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(300L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).build();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testFailsAudience() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, DataSealerException {
        TokenClaimsSet claims = new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(300L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setAudience(Collections.singletonList("foo")).build();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidGrant");
    }

    @Test
    public void testFailsExpired() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, DataSealerException {
        TokenClaimsSet claims = new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now().minusSeconds(120L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).build();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidGrant");
    }

    private class ClaimsValidatorLookup
    implements Function<ProfileRequestContext, ClaimsValidator> {
        private ClaimsValidatorLookup() {
        }

        @Override
        public ClaimsValidator apply(ProfileRequestContext t) {
            ChainingJWTClaimsValidator chain = new ChainingJWTClaimsValidator();
            chain.setId("test");
            chain.setRequireAll(true);
            ArrayList<Object> validators = new ArrayList<Object>();
            RequiredClaimsValidator req = new RequiredClaimsValidator();
            req.setRequiredClaims(Collections.singletonList("jti"));
            validators.add(req);
            validators.add(new NotBeforeClaimsValidator());
            validators.add(new ExpiryClaimsValidator());
            AudienceClaimsValidator aud = new AudienceClaimsValidator();
            aud.setAudienceLookupStrategy(BiFunctionSupport.constant((Object)"issuer"));
            aud.setAllowMissing(true);
            validators.add(aud);
            chain.setClaimValidators(validators);
            return chain;
        }
    }
}

