/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.shibboleth.idp.plugin.oidc.op.criterion.ClientInformationCriterion;
import net.shibboleth.idp.plugin.oidc.op.profile.spring.factory.BasicJWKCredentialFactoryBean;
import net.shibboleth.idp.plugin.oidc.op.security.impl.OIDCClientInformationSignatureSigningParametersResolver;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.impl.OIDCSignatureValidationParameters;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.mockito.Mockito;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCClientInformationSignatureSigningParametersResolverTest
extends OpenSAMLInitBaseTestCase {
    private OIDCClientInformationSignatureSigningParametersResolver resolver;
    private CriteriaSet criteria;
    private OIDCClientMetadata metaData;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.resolver = new OIDCClientInformationSignatureSigningParametersResolver();
        ArrayList<SignatureSigningConfiguration> configs = new ArrayList<SignatureSigningConfiguration>();
        SignatureSigningConfiguration signConfig = (SignatureSigningConfiguration)Mockito.mock(SignatureSigningConfiguration.class);
        Mockito.when((Object)signConfig.getSignatureAlgorithms()).thenReturn(Arrays.asList("RS256", "HS256", "HS384", "HS512", "ES256", "ES384", "ES512"));
        ArrayList<Credential> signCreds = new ArrayList<Credential>();
        BasicJWKCredentialFactoryBean factory = new BasicJWKCredentialFactoryBean();
        factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-es.jwk"));
        factory.afterPropertiesSet();
        signCreds.add((Credential)factory.getObject());
        factory = new BasicJWKCredentialFactoryBean();
        factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-es384.jwk"));
        factory.afterPropertiesSet();
        signCreds.add((Credential)factory.getObject());
        factory = new BasicJWKCredentialFactoryBean();
        factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-es521.jwk"));
        factory.afterPropertiesSet();
        signCreds.add((Credential)factory.getObject());
        factory = new BasicJWKCredentialFactoryBean();
        factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-rs.jwk"));
        factory.afterPropertiesSet();
        signCreds.add((Credential)factory.getObject());
        Mockito.when((Object)signConfig.getSigningCredentials()).thenReturn(signCreds);
        configs.add(signConfig);
        this.criteria = new CriteriaSet(new Criterion[]{new SignatureSigningConfigurationCriterion(configs)});
        this.metaData = new OIDCClientMetadata();
        this.metaData.setIDTokenJWSAlg(JWSAlgorithm.RS256);
        this.metaData.setUserInfoJWSAlg(JWSAlgorithm.ES256);
        OIDCClientInformation clientInformation = new OIDCClientInformation(new ClientID(), new Date(), this.metaData, new Secret("abcdefgh"));
        this.criteria.add((Object)new ClientInformationCriterion(clientInformation));
    }

    @Test
    public void testIdTokenParameters() throws ResolverException {
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"RS256");
        Assert.assertTrue((boolean)(params.getSigningCredential().getPrivateKey() instanceof RSAPrivateKey));
    }

    @Test
    public void testDefaultIdTokenParameters() throws ResolverException {
        this.metaData.setIDTokenJWSAlg(null);
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"RS256");
        Assert.assertTrue((boolean)(params.getSigningCredential().getPrivateKey() instanceof RSAPrivateKey));
    }

    @Test
    public void testIdTokenParametersHS() throws ResolverException {
        this.metaData.setIDTokenJWSAlg(JWSAlgorithm.HS256);
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"HS256");
        Assert.assertNotNull((Object)params.getSigningCredential().getSecretKey());
    }

    @Test
    public void testUserInfoParameters() throws ResolverException {
        this.resolver.setParameterType(OIDCClientInformationSignatureSigningParametersResolver.ParameterType.USERINFO_SIGNING);
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"ES256");
        Assert.assertTrue((boolean)(params.getSigningCredential().getPrivateKey() instanceof ECPrivateKey));
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)params.getSigningCredential().getPrivateKey())).getParams()), (Object)Curve.P_256);
    }

    @Test
    public void testUserInfoParametersES384() throws ResolverException {
        this.metaData.setUserInfoJWSAlg(JWSAlgorithm.ES384);
        this.resolver.setParameterType(OIDCClientInformationSignatureSigningParametersResolver.ParameterType.USERINFO_SIGNING);
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"ES384");
        Assert.assertTrue((boolean)(params.getSigningCredential().getPrivateKey() instanceof ECPrivateKey));
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)params.getSigningCredential().getPrivateKey())).getParams()), (Object)Curve.P_384);
    }

    @Test
    public void testUserInfoParametersES512() throws ResolverException {
        this.metaData.setUserInfoJWSAlg(JWSAlgorithm.ES512);
        this.resolver.setParameterType(OIDCClientInformationSignatureSigningParametersResolver.ParameterType.USERINFO_SIGNING);
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"ES512");
        Assert.assertTrue((boolean)(params.getSigningCredential().getPrivateKey() instanceof ECPrivateKey));
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)params.getSigningCredential().getPrivateKey())).getParams()), (Object)Curve.P_521);
    }

    protected void testSigningValidationHS256(OIDCClientInformationSignatureSigningParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"HS256");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((JWKCredential)params.getValidationCredentials().get(0)).getSecretKey());
    }

    protected void testSigningValidationHS384(OIDCClientInformationSignatureSigningParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"HS384");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((JWKCredential)params.getValidationCredentials().get(0)).getSecretKey());
    }

    protected void testSigningValidationHS512(OIDCClientInformationSignatureSigningParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"HS512");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((JWKCredential)params.getValidationCredentials().get(0)).getSecretKey());
    }

    protected void testSigningValidationES256(OIDCClientInformationSignatureSigningParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"ES256");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)((JWKCredential)params.getValidationCredentials().get(0)).getPublicKey())).getParams()), (Object)Curve.P_256);
    }

    protected void testSigningValidationES384(OIDCClientInformationSignatureSigningParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"ES384");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)((JWKCredential)params.getValidationCredentials().get(0)).getPublicKey())).getParams()), (Object)Curve.P_384);
    }

    protected void testSigningValidationES512(OIDCClientInformationSignatureSigningParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"ES512");
        Assert.assertTrue((params.getValidationCredentials().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)((JWKCredential)params.getValidationCredentials().get(0)).getPublicKey())).getParams()), (Object)Curve.P_521);
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)((JWKCredential)params.getValidationCredentials().get(1)).getPublicKey())).getParams()), (Object)Curve.P_521);
    }
}

