/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.function.Function;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestScopeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ValidateScope;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateScopeTest
extends BaseOIDCResponseActionTest {
    private ValidateScope action;
    private OIDCClientMetadata metaData;

    @BeforeMethod
    private void init() throws ComponentInitializationException, URISyntaxException {
        this.action = new ValidateScope();
        this.action.initialize();
        OIDCMetadataContext oidcCtx = (OIDCMetadataContext)this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        this.metaData = new OIDCClientMetadata();
        Scope scope = new Scope();
        scope.add((Object)OIDCScopeValue.OPENID);
        scope.add((Object)OIDCScopeValue.EMAIL);
        scope.add((Object)OIDCScopeValue.OFFLINE_ACCESS);
        this.metaData.setScope(scope);
        this.metaData.setRedirectionURI(new URI("https://notmatching.org"));
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("test"), null, this.metaData, null, null, null);
        oidcCtx.setClientInformation(information);
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class, true);
        tokenClaimsCtx.getClaims().setClaim("gen", (Object)"value1");
        tokenClaimsCtx.getIdtokenClaims().setClaim("idtoken", (Object)"value2");
        tokenClaimsCtx.getUserinfoClaims().setClaim("userinfo", (Object)"value3");
    }

    @Test
    public void testAuthnSuccess() throws ComponentInitializationException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getScope());
        Assert.assertTrue((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.OPENID));
        Assert.assertTrue((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.EMAIL));
        Assert.assertFalse((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.OFFLINE_ACCESS));
        Assert.assertFalse((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.PROFILE));
    }

    @Test
    public void testAuthnNoScopes() throws ComponentInitializationException {
        this.metaData.setScope(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getScope());
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNotNull((Object)tokenClaimsCtx);
    }

    @Test
    public void testTokenClientCredentials() throws ComponentInitializationException, URISyntaxException {
        this.action = new ValidateScope();
        this.action.setRequestedScopeLookupStrategy((Function)new TokenRequestScopeLookupFunction());
        this.action.initialize();
        TokenRequest req = new TokenRequest(new URI("http://localhost"), (ClientAuthentication)new ClientSecretBasic(new ClientID("s6BhdRkqt3"), new Secret("foo")), (AuthorizationGrant)new ClientCredentialsGrant(), Scope.parse((String)"openid email profile offline_access"));
        this.setTokenRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.OPENID));
        Assert.assertTrue((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.EMAIL));
        Assert.assertTrue((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.OFFLINE_ACCESS));
        Assert.assertFalse((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.PROFILE));
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNotNull((Object)tokenClaimsCtx);
    }

    @Test
    public void testTokenNoGrantedScopes() throws ComponentInitializationException, URISyntaxException {
        this.action = new ValidateScope();
        this.action.setRequestedScopeLookupStrategy((Function)new TokenRequestScopeLookupFunction());
        this.action.initialize();
        TokenRequest req = new TokenRequest(new URI("http://localhost"), (ClientAuthentication)new ClientSecretBasic(new ClientID("s6BhdRkqt3"), new Secret("foo")), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("foo"), new URI("http://localhost")), Scope.parse((String)"openid email profile offline_access"));
        this.setTokenRequest(req);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID("s6BhdRkqt3")).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://localhost")).setScope(new Scope()).setACR(new ACR("0")).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getScope());
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNull((Object)tokenClaimsCtx);
    }

    @Test
    public void testTokenGrantedScopes() throws ComponentInitializationException, URISyntaxException {
        this.action = new ValidateScope();
        this.action.setRequestedScopeLookupStrategy((Function)new TokenRequestScopeLookupFunction());
        this.action.initialize();
        TokenRequest req = new TokenRequest(new URI("http://localhost"), (ClientAuthentication)new ClientSecretBasic(new ClientID("s6BhdRkqt3"), new Secret("foo")), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("foo"), new URI("http://localhost")), Scope.parse((String)"openid email profile offline_access"));
        this.setTokenRequest(req);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID("s6BhdRkqt3")).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://localhost")).setScope(Scope.parse((String)"openid email")).setACR(new ACR("0")).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.OPENID));
        Assert.assertTrue((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.EMAIL));
        Assert.assertFalse((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.OFFLINE_ACCESS));
        Assert.assertFalse((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.PROFILE));
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNull((Object)tokenClaimsCtx);
    }

    @Test
    public void testUserInfoGrantedScopes() throws ComponentInitializationException, URISyntaxException {
        this.action = new ValidateScope();
        this.action.setRequestedScopeLookupStrategy(null);
        this.action.initialize();
        UserInfoRequest req = new UserInfoRequest(new URI("http://localhost"), HTTPRequest.Method.POST, (AccessToken)new BearerAccessToken());
        this.setUserInfoRequest(req);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID("s6BhdRkqt3")).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://localhost")).setScope(Scope.parse((String)"openid email")).setACR(new ACR("0")).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.OPENID));
        Assert.assertTrue((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.EMAIL));
        Assert.assertFalse((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.OFFLINE_ACCESS));
        Assert.assertFalse((boolean)this.respCtx.getScope().contains((Object)OIDCScopeValue.PROFILE));
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNotNull((Object)tokenClaimsCtx);
    }
}

