/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ValidateRequestObject;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.oidc.security.impl.OIDCSignatureValidationParameters;
import net.shibboleth.oidc.security.jwt.claims.impl.AudienceClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.ChainingJWTClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.ExactMatchClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.ExpiryClaimsValidator;
import net.shibboleth.oidc.security.jwt.claims.impl.NotBeforeClaimsValidator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateRequestObjectTest {
    private ProfileRequestContext prc;
    private ValidateRequestObject action;
    private RequestContext requestCtx;
    private OIDCMetadataContext oidcCtx;
    private OIDCAuthenticationResponseContext oidcRespCtx;
    private KeyPair kp;
    private String issuer;

    @BeforeMethod
    public void setup() throws ComponentInitializationException, NoSuchAlgorithmException {
        this.requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        this.oidcCtx = (OIDCMetadataContext)this.prc.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        this.oidcRespCtx = new OIDCAuthenticationResponseContext();
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)this.oidcRespCtx);
        this.issuer = "https://op.example.org/";
        OIDCClientMetadata metaData = new OIDCClientMetadata();
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("test"), null, metaData, new Secret("ultimatetopsecretultimatetopsecret"), null, null);
        this.oidcCtx.setClientInformation(information);
        SecurityParametersContext secCtx = (SecurityParametersContext)this.prc.addSubcontext((BaseContext)new SecurityParametersContext());
        OIDCSignatureValidationParameters params = new OIDCSignatureValidationParameters();
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        this.kp = kpg.generateKeyPair();
        BasicJWKCredential credentialRSA = new BasicJWKCredential();
        credentialRSA.setAlgorithm((Algorithm)JWSAlgorithm.parse((String)"RS256"));
        credentialRSA.setPublicKey(this.kp.getPublic());
        params.getValidationCredentials().add(credentialRSA);
        this.kp = kpg.generateKeyPair();
        BasicJWKCredential credentialRSA2 = new BasicJWKCredential();
        credentialRSA2.setAlgorithm((Algorithm)JWSAlgorithm.parse((String)"RS256"));
        credentialRSA2.setPublicKey(this.kp.getPublic());
        params.getValidationCredentials().add(credentialRSA2);
        params.setSignatureAlgorithm("RS256");
        secCtx.setSignatureSigningParameters((SignatureSigningParameters)params);
        this.action = new ValidateRequestObject();
        this.action.setPlainClaimsValidator((ClaimsValidator)this.buildPlainClaimsValidation());
        this.action.setSignedClaimsValidator((ClaimsValidator)this.buildSignedClaimsValidation("000123"));
        this.action.initialize();
    }

    protected ChainingJWTClaimsValidator buildSignedClaimsValidation(String clientId) {
        ChainingJWTClaimsValidator claimsValidation = new ChainingJWTClaimsValidator();
        ExactMatchClaimsValidator issValidator = new ExactMatchClaimsValidator();
        issValidator.setClaimName("iss");
        issValidator.setValueToMatchLookupStrategy((prc, claimsSet) -> clientId);
        AudienceClaimsValidator audValidator = new AudienceClaimsValidator();
        audValidator.setAudienceLookupStrategy((prc, claimsSet) -> this.issuer);
        claimsValidation.setClaimValidators(List.of(new ExpiryClaimsValidator(), new NotBeforeClaimsValidator(), issValidator, audValidator));
        return claimsValidation;
    }

    protected ChainingJWTClaimsValidator buildPlainClaimsValidation() {
        ChainingJWTClaimsValidator claimsValidation = new ChainingJWTClaimsValidator();
        claimsValidation.setClaimValidators(List.of(new ExpiryClaimsValidator(), new NotBeforeClaimsValidator()));
        return claimsValidation;
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testInitFailsNoValidators() throws ComponentInitializationException {
        this.action = new ValidateRequestObject();
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testInitFailsNoPlainValidator() throws ComponentInitializationException {
        this.action = new ValidateRequestObject();
        this.action.setSignedClaimsValidator((ClaimsValidator)new ChainingJWTClaimsValidator());
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testInitFailsNoSignedValidators() throws ComponentInitializationException {
        this.action = new ValidateRequestObject();
        this.action.setPlainClaimsValidator((ClaimsValidator)new ChainingJWTClaimsValidator());
        this.action.initialize();
    }

    @Test
    public void testInitSuccess() throws ComponentInitializationException {
        this.action = new ValidateRequestObject();
        this.action.setPlainClaimsValidator((ClaimsValidator)new ChainingJWTClaimsValidator());
        this.action.setSignedClaimsValidator((ClaimsValidator)new ChainingJWTClaimsValidator());
        this.action.initialize();
    }

    @Test
    public void testSuccessNoObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testRequestObjectNoMatchingClaims() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().subject("alice").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testRequestObjectAlgMismatch() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        this.oidcCtx.getClientInformation().getOIDCMetadata().setRequestObjectJWSAlg(JWSAlgorithm.RS256);
        JWTClaimsSet ro = new JWTClaimsSet.Builder().subject("alice").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testRequestObjectAlgMatch() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        this.oidcCtx.getClientInformation().getOIDCMetadata().setRequestObjectJWSAlg(new JWSAlgorithm("none"));
        JWTClaimsSet ro = new JWTClaimsSet.Builder().subject("alice").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testRequestObjectClientMismatch() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("client_id", (Object)"not_matching").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testRequestObjectRespTypeMismatch() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("response_type", (Object)"id_token").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testRequestObjectClientRespTypeMatch() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("client_id", (Object)"000123").claim("response_type", (Object)"code token").build();
        ResponseType rt = new ResponseType();
        rt.add(ResponseType.Value.CODE);
        rt.add(ResponseType.Value.TOKEN);
        AuthenticationRequest req = new AuthenticationRequest.Builder(rt, new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).nonce(new Nonce()).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testRequestObjectClientRespTypeMatchWithExpNbf() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("client_id", (Object)"000123").claim("response_type", (Object)"code token").notBeforeTime(Date.from(Instant.now())).expirationTime(Date.from(Instant.now().plusSeconds(60L))).build();
        ResponseType rt = new ResponseType();
        rt.add(ResponseType.Value.CODE);
        rt.add(ResponseType.Value.TOKEN);
        AuthenticationRequest req = new AuthenticationRequest.Builder(rt, new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).nonce(new Nonce()).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testRequestObjectSignedWithRS256() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().issuer("000123").audience(this.issuer).build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testRequestObjectWithExpNbfSignedWithRS256() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().issuer("000123").audience(this.issuer).notBeforeTime(Date.from(Instant.now())).expirationTime(Date.from(Instant.now().plusSeconds(60L))).build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testRequestObjectSignedNotVerified() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        this.kp = kpg.generateKeyPair();
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().subject("alice").build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testRequestObjectSignedWithUnexpectedAlgorithm() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        KeyPair kp = kpg.generateKeyPair();
        kpg.initialize(Curve.P_256.toECParameterSpec());
        ECDSASigner signer = new ECDSASigner((ECPrivateKey)kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().subject("alice").build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.ES256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testRequestObjectSignedWithRS256NoSecParamsCtxt() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        this.prc.removeSubcontext(SecurityParametersContext.class);
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().subject("alice").build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testRequestObjectSignedWithRS256NoSecParams() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        ((SecurityParametersContext)this.prc.getSubcontext(SecurityParametersContext.class)).setSignatureSigningParameters(null);
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().subject("alice").build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testRequestObjectSignedWithRS256NoCredsInSecParams() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        ((OIDCSignatureValidationParameters)((SecurityParametersContext)this.prc.getSubcontext(SecurityParametersContext.class)).getSignatureSigningParameters()).getValidationCredentials().clear();
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().subject("alice").build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testSignedExpiredRequestObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().issuer("000123").audience(this.issuer).expirationTime(Date.from(Instant.now().minus(Duration.ofMinutes(5L)))).build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testSignedNotBeforeInFutureRequestObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().issuer("000123").audience(this.issuer).notBeforeTime(Date.from(Instant.now().plus(Duration.ofMinutes(5L)))).build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testSignedNoIssuerRequstObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().audience(this.issuer).build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testSignedWrongIssuerRequstObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().issuer("invalid").audience(this.issuer).build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testSignedNoAudienceRequstObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().issuer("000123").build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testSignedWrongAudienceRequstObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        JWTClaimsSet ro = new JWTClaimsSet.Builder().issuer("000123").audience("invalid").build();
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), ro);
        signed.sign((JWSSigner)signer);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)signed).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testPlainExpiredRequestObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().expirationTime(Date.from(Instant.now().minus(Duration.ofMinutes(5L)))).build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testPlainNotBeforeInFutureRequestObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, InvalidAlgorithmParameterException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().notBeforeTime(Date.from(Instant.now().plus(Duration.ofMinutes(5L)))).build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }
}

