/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import java.net.URISyntaxException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SignIDToken;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SignIDTokenTest
extends BaseOIDCResponseActionTest {
    private SignIDToken action = new SignIDToken();
    SecurityParametersContext spCtx;

    private void init(String algo, Credential credential) throws ComponentInitializationException, URISyntaxException {
        this.action.initialize();
        this.spCtx = new SecurityParametersContext();
        SignatureSigningParameters params = new SignatureSigningParameters();
        this.spCtx.setSignatureSigningParameters(params);
        params.setSigningCredential(credential);
        params.setSignatureAlgorithm(algo);
        this.profileRequestCtx.addSubcontext((BaseContext)this.spCtx);
    }

    @Test
    public void testNoSecCtx() throws ComponentInitializationException {
        this.action.initialize();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getProcessedToken());
    }

    @Test
    public void testNoSigningParameters() throws ComponentInitializationException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        this.spCtx.setSignatureSigningParameters(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getProcessedToken());
    }

    @Test
    public void testNoIdToken() throws ComponentInitializationException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        Event event = this.action.execute(this.requestCtx);
        this.respCtx.setIDToken(null);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    private void testSuccessMessage(JWSVerifier verifier) throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getProcessedToken());
        Assert.assertTrue((boolean)((SignedJWT)this.respCtx.getProcessedToken()).verify(verifier));
    }

    @Test
    public void testSuccessMessageRS256() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("RS256", this.credentialRSA);
        this.testSuccessMessage((JWSVerifier)new RSASSAVerifier((RSAPublicKey)this.credentialRSA.getPublicKey()));
    }

    @Test
    public void testSuccessMessageRS384() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("RS384", this.credentialRSA);
        this.testSuccessMessage((JWSVerifier)new RSASSAVerifier((RSAPublicKey)this.credentialRSA.getPublicKey()));
    }

    @Test
    public void testSuccessMessageRS512() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("RS512", this.credentialRSA);
        this.testSuccessMessage((JWSVerifier)new RSASSAVerifier((RSAPublicKey)this.credentialRSA.getPublicKey()));
    }

    @Test
    public void testSuccessMessageES256() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("ES256", this.credentialEC256);
        this.testSuccessMessage((JWSVerifier)new ECDSAVerifier((ECPublicKey)this.credentialEC256.getPublicKey()));
    }

    @Test
    public void testSuccessMessageES384() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("ES384", this.credentialEC384);
        this.testSuccessMessage((JWSVerifier)new ECDSAVerifier((ECPublicKey)this.credentialEC384.getPublicKey()));
    }

    @Test
    public void testSuccessMessageES512() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("ES512", this.credentialEC521);
        this.testSuccessMessage((JWSVerifier)new ECDSAVerifier((ECPublicKey)this.credentialEC521.getPublicKey()));
    }

    @Test
    public void testSuccessMessageHS256() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("HS256", this.credentialHMAC);
        this.testSuccessMessage((JWSVerifier)new MACVerifier(this.credentialHMAC.getSecretKey()));
    }

    @Test
    public void testSuccessMessageHS384() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("HS384", this.credentialHMAC);
        this.testSuccessMessage((JWSVerifier)new MACVerifier(this.credentialHMAC.getSecretKey()));
    }

    @Test
    public void testSuccessMessageHS512() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("HS512", this.credentialHMAC);
        this.testSuccessMessage((JWSVerifier)new MACVerifier(this.credentialHMAC.getSecretKey()));
    }
}

