/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.PreferredPrincipalContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.impl.DefaultAuthenticationResultSerializer;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetAuthenticationContextClassReferenceToResponseContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.storage.StorageSerializer;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SetAuthenticationContextClassReferenceToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetAuthenticationContextClassReferenceToResponseContext action;
    private List<Principal> principals;

    @BeforeMethod
    private void init() throws ComponentInitializationException {
        this.action = new SetAuthenticationContextClassReferenceToResponseContext();
        this.action.initialize();
        this.profileRequestCtx.addSubcontext((BaseContext)new AuthenticationContext());
        this.principals = new ArrayList<Principal>();
        this.principals.add((Principal)new AuthenticationContextClassReferencePrincipal("1"));
        this.principals.add((Principal)new AuthenticationContextClassReferencePrincipal("2"));
        this.principals.add((Principal)new AuthenticationContextClassReferencePrincipal("3"));
        RequestedPrincipalContext rpCtx = new RequestedPrincipalContext();
        rpCtx.setOperator(AuthnContextComparisonTypeEnumeration.EXACT.toString());
        rpCtx.setRequestedPrincipals(this.principals);
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class, true)).addSubcontext((BaseContext)rpCtx, true);
        Subject authSubject = new Subject();
        authSubject.getPrincipals().add((Principal)new AuthenticationContextClassReferencePrincipal("2"));
        authSubject.getPrincipals().add((Principal)new AuthenticationContextClassReferencePrincipal("4"));
        AuthenticationResult result = new AuthenticationResult("flowId", authSubject);
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class)).setAuthenticationResult(result);
        AuthenticationFlowDescriptor descriptor = new AuthenticationFlowDescriptor();
        descriptor.setId("flowId");
        descriptor.setPrincipalWeightMap(Collections.singletonMap(new AuthenticationContextClassReferencePrincipal("2"), 10));
        descriptor.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        descriptor.initialize();
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class)).getAvailableFlows().put("flowId", descriptor);
    }

    @Test
    public void testSuccessRequestedACR() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)this.respCtx.getAcr(), (Object)new ACR("2"));
    }

    @Test
    public void testSuccessPreferredACR() {
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class)).removeSubcontext(RequestedPrincipalContext.class);
        PreferredPrincipalContext ppCtx = new PreferredPrincipalContext();
        ppCtx.setPreferredPrincipals(this.principals);
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class, true)).addSubcontext((BaseContext)ppCtx, true);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)this.respCtx.getAcr(), (Object)new ACR("2"));
    }

    @Test
    public void testSuccessPreferredACRNotMatching() {
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class)).removeSubcontext(RequestedPrincipalContext.class);
        PreferredPrincipalContext ppCtx = new PreferredPrincipalContext();
        this.principals.clear();
        this.principals.add((Principal)new AuthenticationContextClassReferencePrincipal("1"));
        ppCtx.setPreferredPrincipals(this.principals);
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class, true)).addSubcontext((BaseContext)ppCtx, true);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)this.respCtx.getAcr().equals((Object)new ACR("2")));
    }

    @Test
    public void testSuccessPreferredACRNotMatching2() {
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class)).removeSubcontext(RequestedPrincipalContext.class);
        PreferredPrincipalContext ppCtx = new PreferredPrincipalContext();
        this.principals.clear();
        this.principals.add((Principal)new AuthenticationContextClassReferencePrincipal("1"));
        ppCtx.setPreferredPrincipals(this.principals);
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class, true)).addSubcontext((BaseContext)ppCtx, true);
        AuthenticationResult result = new AuthenticationResult("flowId", new Subject());
        ((AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class)).setAuthenticationResult(result);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getAcr());
    }

    @Test
    public void testFailNoAuthContext() {
        this.profileRequestCtx.removeSubcontext(AuthenticationContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }
}

