/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetAuthenticationContextClassReferenceFromAuthzCodeToResponseContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SetAuthenticationContextClassReferenceFromAuthzCodeToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetAuthenticationContextClassReferenceFromAuthzCodeToResponseContext action;

    @BeforeMethod
    private void init() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException {
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject(this.subject).setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        this.action = new SetAuthenticationContextClassReferenceFromAuthzCodeToResponseContext();
        this.action.initialize();
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException, DataSealerException {
        this.respCtx.setAcr(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)this.respCtx.getAcr(), (Object)new ACR("0"));
    }

    @Test
    public void testFailsNoToken() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException, DataSealerException {
        this.respCtx.setAuthorizationGrantClaimsSet(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }
}

