/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.net.URI;
import java.util.ArrayList;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.PreferredPrincipalContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ProcessRequestedAuthnContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProcessRequestedAuthnContextTest
extends BaseOIDCResponseActionTest {
    private ProcessRequestedAuthnContext action;

    private void init() throws ComponentInitializationException {
        this.action = new ProcessRequestedAuthnContext();
        this.action.initialize();
    }

    @Test
    public void testNoAuthnContext() throws ComponentInitializationException {
        this.init();
        ArrayList<ACR> acrValues = new ArrayList<ACR>();
        acrValues.add(new ACR("1"));
        acrValues.add(new ACR("2"));
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).acrValues(acrValues).state(new State()).build();
        this.setAuthenticationRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testNoReqACRSuccess() throws ComponentInitializationException {
        this.init();
        this.profileRequestCtx.addSubcontext((BaseContext)new AuthenticationContext());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testSuccessACRParam() throws ComponentInitializationException {
        this.init();
        ArrayList<ACR> acrValues = new ArrayList<ACR>();
        acrValues.add(new ACR("1"));
        acrValues.add(new ACR("2"));
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("clientid"), URI.create("https://example.com/callback")).acrValues(acrValues).state(new State()).build();
        this.setAuthenticationRequest(req);
        AuthenticationContext ctx = (AuthenticationContext)this.profileRequestCtx.addSubcontext((BaseContext)new AuthenticationContext());
        Event event = this.action.execute(this.requestCtx);
        PreferredPrincipalContext rpCtx = (PreferredPrincipalContext)ctx.getSubcontext(PreferredPrincipalContext.class, false);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)rpCtx);
        Assert.assertTrue((boolean)rpCtx.getPreferredPrincipals().contains(new AuthenticationContextClassReferencePrincipal("1")));
        Assert.assertTrue((boolean)rpCtx.getPreferredPrincipals().contains(new AuthenticationContextClassReferencePrincipal("2")));
    }

    @Test
    public void testSuccessRequestedClaims1() throws ComponentInitializationException {
        this.init();
        ClaimsSetRequest.Entry entry = new ClaimsSetRequest.Entry("acr").withValue("1");
        OIDCClaimsRequest claims = new OIDCClaimsRequest().withIDTokenClaimsRequest(new ClaimsSetRequest().add(entry));
        this.respCtx.setRequestedClaims(claims);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("clientid"), URI.create("https://example.com/callback")).claims(claims).state(new State()).build();
        this.setAuthenticationRequest(req);
        AuthenticationContext ctx = (AuthenticationContext)this.profileRequestCtx.addSubcontext((BaseContext)new AuthenticationContext());
        Event event = this.action.execute(this.requestCtx);
        PreferredPrincipalContext ppCtx = (PreferredPrincipalContext)ctx.getSubcontext(PreferredPrincipalContext.class, false);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)ppCtx);
        Assert.assertTrue((boolean)ppCtx.getPreferredPrincipals().contains(new AuthenticationContextClassReferencePrincipal("1")));
    }

    @Test
    public void testSuccessRequestedClaims2() throws ComponentInitializationException {
        this.init();
        ArrayList<String> acrs = new ArrayList<String>();
        acrs.add("1");
        acrs.add("2");
        ClaimsSetRequest.Entry entry = new ClaimsSetRequest.Entry("acr").withClaimRequirement(ClaimRequirement.ESSENTIAL).withValues(acrs);
        OIDCClaimsRequest claims = new OIDCClaimsRequest().withIDTokenClaimsRequest(new ClaimsSetRequest().add(entry));
        this.respCtx.setRequestedClaims(claims);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("clientid"), URI.create("https://example.com/callback")).claims(claims).state(new State()).build();
        this.setAuthenticationRequest(req);
        AuthenticationContext ctx = (AuthenticationContext)this.profileRequestCtx.addSubcontext((BaseContext)new AuthenticationContext());
        Event event = this.action.execute(this.requestCtx);
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)ctx.getSubcontext(RequestedPrincipalContext.class, false);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)rpCtx);
        Assert.assertTrue((boolean)rpCtx.getRequestedPrincipals().contains(new AuthenticationContextClassReferencePrincipal("1")));
        Assert.assertTrue((boolean)rpCtx.getRequestedPrincipals().contains(new AuthenticationContextClassReferencePrincipal("2")));
    }

    @Test
    public void testSuccessRequestedClaims3() throws ComponentInitializationException {
        this.init();
        OIDCClaimsRequest claims = new OIDCClaimsRequest().withIDTokenClaimsRequest(new ClaimsSetRequest().add("acr"));
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("clientid"), URI.create("https://example.com/callback")).claims(claims).state(new State()).build();
        this.setAuthenticationRequest(req);
        AuthenticationContext ctx = (AuthenticationContext)this.profileRequestCtx.addSubcontext((BaseContext)new AuthenticationContext());
        Event event = this.action.execute(this.requestCtx);
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)ctx.getSubcontext(RequestedPrincipalContext.class, false);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)rpCtx);
    }
}

