/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.openid.connect.sdk.claims.AMR;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ManipulateClaimsForIDToken;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManipulateClaimsForIDTokenTest
extends BaseOIDCResponseActionTest {
    private ManipulateClaimsForIDToken action;

    private void init() throws ComponentInitializationException {
        this.init(null);
    }

    private void init(BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) throws ComponentInitializationException {
        this.action = new ManipulateClaimsForIDToken();
        this.action.initialize();
        OIDCAuthorizationConfiguration config = new OIDCAuthorizationConfiguration();
        config.setIDTokenManipulationStrategy(strategy);
        this.rpCtx.setProfileConfig((ProfileConfiguration)config);
    }

    @Test
    public void testNoCtx() throws ComponentInitializationException {
        this.init();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testSuccessSameMapDoesntChangeContents() throws ComponentInitializationException, ParseException {
        Instant now = Instant.now();
        this.setIdTokenToResponseContext("iss", "sub", "aud", now, now);
        Assert.assertEquals((int)this.respCtx.getIDToken().toJSONObject().size(), (int)5);
        this.init((prc, map) -> map);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        IDTokenClaimsSet idToken = this.respCtx.getIDToken();
        Assert.assertEquals((int)idToken.toJSONObject().size(), (int)5);
        Assert.assertEquals((String)idToken.getSubject().getValue(), (String)"sub");
        Assert.assertEquals((String)idToken.getIssuer().getValue(), (String)"iss");
        Assert.assertEquals((Collection)idToken.getAudience(), (Collection)Audience.create((String[])new String[]{"aud"}));
        Assert.assertEquals((long)idToken.getIssueTime().toInstant().getEpochSecond(), (long)now.getEpochSecond());
        Assert.assertEquals((long)idToken.getExpirationTime().toInstant().getEpochSecond(), (long)now.getEpochSecond());
    }

    @Test
    public void testSuccessManipulationForIss() throws ComponentInitializationException, ParseException {
        Instant now = Instant.now();
        this.setIdTokenToResponseContext("iss", "sub", "aud", now, now);
        Assert.assertEquals((int)this.respCtx.getIDToken().toJSONObject().size(), (int)5);
        Map<String, Object> manipulatedClaims = Map.of("iss", "manipulatedIss", "sub", "sub", "aud", List.of("aud"), "exp", now.getEpochSecond(), "iat", now.getEpochSecond());
        this.init(this.mockFunction(manipulatedClaims));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        IDTokenClaimsSet idToken = this.respCtx.getIDToken();
        Assert.assertEquals((int)idToken.toJSONObject().size(), (int)5);
        Assert.assertEquals((String)idToken.getSubject().getValue(), (String)"sub");
        Assert.assertEquals((String)idToken.getIssuer().getValue(), (String)"manipulatedIss");
        Assert.assertEquals((Collection)idToken.getAudience(), (Collection)Audience.create((String[])new String[]{"aud"}));
        Assert.assertEquals((long)idToken.getIssueTime().toInstant().getEpochSecond(), (long)now.getEpochSecond());
        Assert.assertEquals((long)idToken.getExpirationTime().toInstant().getEpochSecond(), (long)now.getEpochSecond());
    }

    @Test
    public void testSuccessManipulationAddStandardClaims() throws ComponentInitializationException, ParseException {
        Instant now = Instant.now();
        this.setIdTokenToResponseContext("iss", "sub", "aud", now, now);
        Assert.assertEquals((int)this.respCtx.getIDToken().toJSONObject().size(), (int)5);
        Map<String, Object> manipulatedClaims = Map.of("iss", "manipulatedIss", "sub", "sub", "aud", List.of("aud"), "exp", now.getEpochSecond(), "iat", now.getEpochSecond(), "acr", "password", "amr", List.of("face"));
        this.init(this.mockFunction(manipulatedClaims));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        IDTokenClaimsSet idToken = this.respCtx.getIDToken();
        Assert.assertEquals((int)idToken.toJSONObject().size(), (int)7);
        Assert.assertEquals((String)idToken.getSubject().getValue(), (String)"sub");
        Assert.assertEquals((String)idToken.getIssuer().getValue(), (String)"manipulatedIss");
        Assert.assertEquals((Collection)idToken.getAudience(), (Collection)Audience.create((String[])new String[]{"aud"}));
        Assert.assertEquals((long)idToken.getIssueTime().toInstant().getEpochSecond(), (long)now.getEpochSecond());
        Assert.assertEquals((long)idToken.getExpirationTime().toInstant().getEpochSecond(), (long)now.getEpochSecond());
        Assert.assertEquals((String)idToken.getACR().getValue(), (String)"password");
        Assert.assertEquals((Collection)idToken.getAMR(), List.of(AMR.FACE));
    }

    @Test
    public void testSuccessManipulationAddCustomClaims() throws ComponentInitializationException, ParseException {
        Instant now = Instant.now();
        this.setIdTokenToResponseContext("iss", "sub", "aud", now, now);
        Assert.assertEquals((int)this.respCtx.getIDToken().toJSONObject().size(), (int)5);
        Map<String, Object> manipulatedClaims = Map.of("iss", "manipulatedIss", "sub", "sub", "aud", List.of("aud"), "exp", now.getEpochSecond(), "iat", now.getEpochSecond(), "custom1", 3, "custom2", List.of("customV1", "customV2"));
        this.init(this.mockFunction(manipulatedClaims));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        IDTokenClaimsSet idToken = this.respCtx.getIDToken();
        Assert.assertEquals((int)idToken.toJSONObject().size(), (int)7);
        Assert.assertEquals((String)idToken.getSubject().getValue(), (String)"sub");
        Assert.assertEquals((String)idToken.getIssuer().getValue(), (String)"manipulatedIss");
        Assert.assertEquals((Collection)idToken.getAudience(), (Collection)Audience.create((String[])new String[]{"aud"}));
        Assert.assertEquals((long)idToken.getIssueTime().toInstant().getEpochSecond(), (long)now.getEpochSecond());
        Assert.assertEquals((long)idToken.getExpirationTime().toInstant().getEpochSecond(), (long)now.getEpochSecond());
        Assert.assertEquals((String)idToken.getNumberClaim("custom1").toString(), (String)Integer.valueOf(3).toString());
        Assert.assertEquals((Collection)idToken.getStringListClaim("custom2"), List.of("customV1", "customV2"));
    }

    @Test
    public void testFailedManipulationDueMissingIss() throws ComponentInitializationException, ParseException {
        Instant now = Instant.now();
        this.setIdTokenToResponseContext("iss", "sub", "aud", now, now);
        Map<String, Object> manipulatedClaims = Map.of("sub", "sub", "aud", List.of("aud"), "exp", now.getEpochSecond(), "iat", now.getEpochSecond());
        this.init(this.mockFunction(manipulatedClaims));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testFailedManipulationDueInvalidIatFormat() throws ComponentInitializationException, ParseException {
        Instant now = Instant.now();
        this.setIdTokenToResponseContext("iss", "sub", "aud", now, now);
        Map<String, Object> manipulatedClaims = Map.of("iss", "iss", "sub", "sub", "aud", List.of("aud"), "exp", now.getEpochSecond(), "iat", "invalidFormat");
        this.init(this.mockFunction(manipulatedClaims));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    protected BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> mockFunction(Map<String, Object> result) {
        BiFunction function = (BiFunction)Mockito.mock(BiFunction.class);
        Mockito.when(function.apply(Mockito.any(), Mockito.any())).thenReturn(result);
        return function;
    }
}

