/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Date;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.InitializeOutboundAuthenticationResponseMessageContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.InformationURL;
import org.opensaml.saml.ext.saml2mdui.PrivacyStatementURL;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeOutboundAuthenticationResponseMessageContextTest {
    private InitializeOutboundAuthenticationResponseMessageContext action;
    private RequestContext requestCtx;
    protected OIDCMetadataContext metadataCtx;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void init() throws ComponentInitializationException, ParseException {
        AuthenticationRequest request = AuthenticationRequest.parse((String)"response_type=id_token+token&client_id=s6BhdRkqt3&login_hint=foo&redirect_uri=https%3A%2F%2Fclient.example.org%2Fcb&scope=openid%20email%20profile%20offline_access&state=af0ifjsldkj&nonce=n-0S6_WzA2Mj");
        this.action = new InitializeOutboundAuthenticationResponseMessageContext();
        this.action.initialize();
        this.requestCtx = new RequestContextBuilder().setInboundMessage((Object)request).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        this.prc.getSubcontext(RelyingPartyContext.class, true);
        this.metadataCtx = (OIDCMetadataContext)this.prc.getInboundMessageContext().addSubcontext((BaseContext)new OIDCMetadataContext());
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("clientId"), new Date(), new OIDCClientMetadata(), new Secret());
        this.metadataCtx.setClientInformation(information);
    }

    @Test
    public void testSuccess() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
    }

    @Test
    public void nonExistentLogo() throws URISyntaxException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setLogoURI(new URI("file:/nonexistent.png"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
    }

    @Test
    public void emptyLogo() throws URISyntaxException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setLogoURI(new URI(this.getClass().getResource("/misc/invalidlogo.png").toString()));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
    }

    @Test
    public void successLogo() throws URISyntaxException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setLogoURI(new URI(this.getClass().getResource("/misc/logo.png").toString()));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        SAMLMetadataContext ctx = new SAMLMetadataContextLookupFunction().apply(this.prc);
        Extensions exts = ctx.getRoleDescriptor().getExtensions();
        if (exts != null) {
            for (XMLObject object : exts.getOrderedChildren()) {
                if (!(object instanceof UIInfo)) continue;
                Assert.assertTrue((((UIInfo)object).getLogos().size() == 1 ? 1 : 0) != 0);
                return;
            }
        }
        Assert.assertFalse((boolean)false, (String)"There is no logo for rp");
    }

    @Test
    public void successPolicy() throws URISyntaxException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setPolicyURI(new URI("http://policy.example.com"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        SAMLMetadataContext ctx = new SAMLMetadataContextLookupFunction().apply(this.prc);
        Extensions exts = ctx.getRoleDescriptor().getExtensions();
        if (exts != null) {
            for (XMLObject object : exts.getOrderedChildren()) {
                if (!(object instanceof UIInfo)) continue;
                Assert.assertTrue((((UIInfo)object).getPrivacyStatementURLs().size() == 1 ? 1 : 0) != 0);
                Assert.assertEquals((String)"http://policy.example.com", (String)((PrivacyStatementURL)((UIInfo)object).getPrivacyStatementURLs().get(0)).getURI());
                return;
            }
        }
        Assert.assertFalse((boolean)false, (String)"There is no privacy statement for rp");
    }

    @Test
    public void successTos() throws URISyntaxException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setTermsOfServiceURI(new URI("http://tos.example.com"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        SAMLMetadataContext ctx = new SAMLMetadataContextLookupFunction().apply(this.prc);
        Extensions exts = ctx.getRoleDescriptor().getExtensions();
        if (exts != null) {
            for (XMLObject object : exts.getOrderedChildren()) {
                if (!(object instanceof UIInfo)) continue;
                Assert.assertTrue((((UIInfo)object).getInformationURLs().size() == 1 ? 1 : 0) != 0);
                Assert.assertEquals((String)"http://tos.example.com", (String)((InformationURL)((UIInfo)object).getInformationURLs().get(0)).getURI());
                return;
            }
        }
        Assert.assertFalse((boolean)false, (String)"There is no information url for rp");
    }

    @Test
    public void successContacts() throws URISyntaxException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setEmailContacts(Arrays.asList("contact1@example.com", "contact2@example.com"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        SAMLMetadataContext ctx = new SAMLMetadataContextLookupFunction().apply(this.prc);
        Assert.assertEquals((int)2, (int)ctx.getEntityDescriptor().getContactPersons().size());
        Assert.assertEquals((String)"mailto:contact1@example.com", (String)((EmailAddress)((ContactPerson)ctx.getEntityDescriptor().getContactPersons().get(0)).getEmailAddresses().get(0)).getURI());
        Assert.assertEquals((String)"mailto:contact2@example.com", (String)((EmailAddress)((ContactPerson)ctx.getEntityDescriptor().getContactPersons().get(1)).getEmailAddresses().get(0)).getURI());
    }

    @Test
    public void successService() throws URISyntaxException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setName("test rp");
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        SAMLMetadataContext ctx = new SAMLMetadataContextLookupFunction().apply(this.prc);
        Extensions exts = ctx.getRoleDescriptor().getExtensions();
        if (exts != null) {
            for (XMLObject object : exts.getOrderedChildren()) {
                if (!(object instanceof UIInfo)) continue;
                Assert.assertTrue((((UIInfo)object).getDisplayNames().size() == 1 ? 1 : 0) != 0);
                Assert.assertEquals((String)"test rp", (String)((DisplayName)((UIInfo)object).getDisplayNames().get(0)).getValue());
                return;
            }
        }
        Assert.assertFalse((boolean)false, (String)"There is no service name for rp");
    }
}

