/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationMetadataPolicyContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.mockito.Mockito;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.Test;

public abstract class BaseOIDCClientMetadataPopulationTest {
    protected AbstractOIDCClientMetadataPopulationAction action;
    protected RequestContext requestCtx;
    protected ProfileRequestContext profileRequestCtx;

    protected void setUpContext(OIDCClientMetadata input, OIDCClientMetadata output) throws ComponentInitializationException {
        OIDCClientRegistrationRequest request = new OIDCClientRegistrationRequest(null, input, null);
        this.requestCtx = new RequestContextBuilder().setInboundMessage((Object)request).buildRequestContext();
        this.profileRequestCtx = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        this.profileRequestCtx.setOutboundMessageContext(new MessageContext());
        OIDCClientRegistrationResponseContext responseCtx = new OIDCClientRegistrationResponseContext();
        OIDCClientRegistrationMetadataPolicyContext policyCtx = (OIDCClientRegistrationMetadataPolicyContext)this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCClientRegistrationMetadataPolicyContext.class, true);
        responseCtx.setClientMetadata(output);
        policyCtx.setPolicyEnforcedMetadata(input);
        this.profileRequestCtx.getOutboundMessageContext().addSubcontext((BaseContext)responseCtx);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    protected void testNullInputStrategy() {
        this.action = this.constructAction();
        this.action.setOidcInputMetadataLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    protected void testNullOutputStrategy() {
        this.action = this.constructAction();
        this.action.setOidcOutputMetadataLookupStrategy(null);
    }

    @Test
    protected void testNoRequestMetadata() throws ComponentInitializationException {
        this.action = this.constructAction();
        this.action.setOidcInputMetadataLookupStrategy(this.initializeNullLookup());
        this.action.initialize();
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessageContext");
    }

    @Test
    protected void testNoResponseMetadata() throws ComponentInitializationException {
        this.action = this.constructAction();
        this.action.setOidcOutputMetadataLookupStrategy(this.initializeNullLookup());
        this.action.initialize();
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessageContext");
    }

    protected ContextDataLookupFunction<ProfileRequestContext, OIDCClientMetadata> initializeNullLookup() throws ComponentInitializationException {
        this.setUpContext(new OIDCClientMetadata(), new OIDCClientMetadata());
        ContextDataLookupFunction lookup = (ContextDataLookupFunction)Mockito.mock(ContextDataLookupFunction.class);
        Mockito.when((Object)((OIDCClientMetadata)lookup.apply((Object)((ProfileRequestContext)Mockito.any())))).thenReturn(null);
        return lookup;
    }

    protected abstract AbstractOIDCClientMetadataPopulationAction constructAction();
}

