/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddTokenDeliveryAttributesToClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddTokenDeliveryAttributesToClaimsSetTest
extends BaseOIDCResponseActionTest {
    private AddTokenDeliveryAttributesToClaimsSet action;
    private OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx;

    @BeforeMethod
    private void init() throws ComponentInitializationException {
        this.action = new AddTokenDeliveryAttributesToClaimsSet();
        this.action.setTargetIDToken(true);
        this.action.initialize();
        this.tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.addSubcontext((BaseContext)new OIDCAuthenticationResponseTokenClaimsContext());
        this.tokenClaimsCtx.getClaims().setClaim("gen", (Object)"value1");
        this.tokenClaimsCtx.getIdtokenClaims().setClaim("idtoken", (Object)"value2");
        this.tokenClaimsCtx.getUserinfoClaims().setClaim("userinfo", (Object)"value3");
    }

    @Test
    public void testNoIdToken() throws ComponentInitializationException, ParseException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoTokenDeliveryAttributes() throws ComponentInitializationException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        this.respCtx.removeSubcontext((BaseContext)this.tokenClaimsCtx);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testNoTokenDeliveryAttributes2() throws ComponentInitializationException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        this.respCtx.addSubcontext((BaseContext)new OIDCAuthenticationResponseTokenClaimsContext(), true);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testIdTokenDeliveryAttributes() throws ComponentInitializationException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("gen").equals("value1"));
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("idtoken").equals("value2"));
        Assert.assertNull((Object)this.respCtx.getIDToken().getClaim("userinfo"));
    }

    @Test
    public void testUserInfoDeliveryAttributes() throws ComponentInitializationException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        this.action = new AddTokenDeliveryAttributesToClaimsSet();
        this.action.setTargetIDToken(false);
        this.action.initialize();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("gen").equals("value1"));
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("userinfo").equals("value3"));
        Assert.assertNull((Object)this.respCtx.getIDToken().getClaim("idtoken"));
    }
}

