/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddJwksToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.mockito.Mockito;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddJwksToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    URI MOCK_URI = URI.create("https://mock.com");

    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        AddJwksToClientMetadata action = new AddJwksToClientMetadata();
        try {
            action.setHttpClient(this.buildMockHttpClient("mock"));
        }
        catch (IOException e) {
            return null;
        }
        return action;
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.action = this.constructAction();
        this.action.initialize();
    }

    protected HttpClient buildMockHttpClient(String contents) throws ClientProtocolException, IOException {
        HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)new StringEntity(contents));
        HttpClient mockClient = (HttpClient)Mockito.mock(HttpClient.class);
        Mockito.when((Object)mockClient.execute((HttpUriRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)mockResponse);
        return mockClient;
    }

    protected AddJwksToClientMetadata constructWithProperties(String contents) throws Exception {
        AddJwksToClientMetadata action = new AddJwksToClientMetadata();
        action.setHttpClient(this.buildMockHttpClient(contents));
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSProtocols(Collections.singleton("TLSv1"));
        action.setHttpClientSecurityParameters(params);
        action.initialize();
        return action;
    }

    @Test
    public void testEmptyContents() throws Exception {
        this.action = this.constructWithProperties("");
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setJWKSetURI(this.MOCK_URI);
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
    }

    @Test
    public void testInvalidJson() throws Exception {
        this.action = this.constructWithProperties("not json");
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setJWKSetURI(this.MOCK_URI);
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
    }

    @Test
    public void testValidJsonNoKeys() throws Exception {
        this.action = this.constructWithProperties("{ \"mock\" : \"mock\" }");
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setJWKSetURI(this.MOCK_URI);
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
    }

    @Test
    public void testValidJwks() throws Exception {
        String json = new String(Files.readAllBytes(Paths.get(this.getClass().getResource("/net/shibboleth/idp/oidc/metadata/impl/public_keys.jwks").toURI())));
        this.action = this.constructWithProperties(json);
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setJWKSetURI(this.MOCK_URI);
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)result.getJWKSetURI(), (Object)this.MOCK_URI);
    }
}

