/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddContactsToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddContactsToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    AddContactsToClientMetadata action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddContactsToClientMetadata();
        this.action.initialize();
    }

    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        return new AddContactsToClientMetadata();
    }

    @Test
    public void testNull() throws ComponentInitializationException {
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(new OIDCClientMetadata(), result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertNull((Object)result.getEmailContacts());
    }

    @Test
    public void testEmpty() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setEmailContacts(new ArrayList());
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertNull((Object)result.getEmailContacts());
    }

    @Test
    public void testSuccess() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        ArrayList<String> contacts = new ArrayList<String>();
        String address = "root@example.org";
        contacts.add("root@example.org");
        request.setEmailContacts(contacts);
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        List resultContacts = result.getEmailContacts();
        Assert.assertNotNull((Object)resultContacts);
        Assert.assertEquals((int)resultContacts.size(), (int)1);
        Assert.assertEquals((String)((String)resultContacts.get(0)), (String)"root@example.org");
    }
}

