/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.nimbusds.oauth2.sdk.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddAttributesToClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.attribute.transcoding.AbstractOIDCAttributeTranscoder;
import net.shibboleth.oidc.attribute.transcoding.impl.OIDCStringAttributeTranscoder;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import net.shibboleth.utilities.java.support.test.service.MockReloadableService;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddAttributesToClaimsSetTest
extends BaseOIDCResponseActionTest {
    private AttributeTranscoderRegistryImpl registry;
    private AddAttributesToClaimsSet action;

    @BeforeMethod
    public void setup() throws ComponentInitializationException {
        ((OIDCAuthorizationConfiguration)this.rpCtx.getProfileConfig()).setAlwaysIncludedAttributes(Set.of("test1", "test3", "test4"));
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        OIDCStringAttributeTranscoder transcoder = new OIDCStringAttributeTranscoder();
        transcoder.initialize();
        HashMap<String, String> rule1 = new HashMap<String, String>();
        rule1.put("id", "test1");
        rule1.put("transcoder", (String)transcoder);
        rule1.put("oidc.name", "test1");
        HashMap<String, String> rule2 = new HashMap<String, String>();
        rule2.put("id", "test2");
        rule2.put("transcoder", (String)transcoder);
        rule2.put("oidc.name", "test2");
        HashMap<String, String> rule3 = new HashMap<String, String>();
        rule3.put("id", "test3");
        rule3.put("transcoder", (String)transcoder);
        rule3.put("oidc.name", "test3claim");
        HashMap<String, String> rule4 = new HashMap<String, String>();
        rule4.put("id", "test4");
        rule4.put("transcoder", (String)transcoder);
        rule4.put("oidc.name", "test4claim");
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractOIDCAttributeTranscoder.NamingFunction())));
        this.registry.setTranscoderRegistry(List.of(new TranscodingRule(rule1), new TranscodingRule(rule2), new TranscodingRule(rule3), new TranscodingRule(rule4)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
        this.action = new AddAttributesToClaimsSet();
        this.action.setTranscoderRegistry((ReloadableService)new MockReloadableService((ServiceableComponent)this.registry));
        this.action.initialize();
    }

    @AfterMethod
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    private void setAttributeContext() {
        IdPAttribute attribute1 = new IdPAttribute("test1");
        ArrayList<StringAttributeValue> stringAttributeValues1 = new ArrayList<StringAttributeValue>();
        stringAttributeValues1.add(new StringAttributeValue("value1"));
        stringAttributeValues1.add(new StringAttributeValue("value2"));
        attribute1.setValues(stringAttributeValues1);
        IdPAttribute attribute2 = new IdPAttribute("test2");
        ArrayList<StringAttributeValue> stringAttributeValues2 = new ArrayList<StringAttributeValue>();
        stringAttributeValues2.add(new StringAttributeValue("value"));
        attribute2.setValues(stringAttributeValues2);
        IdPAttribute attribute3 = new IdPAttribute("test3");
        ArrayList<StringAttributeValue> stringAttributeValues3 = new ArrayList<StringAttributeValue>();
        stringAttributeValues3.add(new StringAttributeValue("value3"));
        attribute3.setValues(stringAttributeValues3);
        IdPAttribute attribute4 = new IdPAttribute("test4");
        ArrayList<StringAttributeValue> stringAttributeValues4 = new ArrayList<StringAttributeValue>();
        stringAttributeValues4.add(new StringAttributeValue("value4"));
        attribute4.setValues(stringAttributeValues4);
        IdPAttribute attribute5 = new IdPAttribute("test5");
        ArrayList<StringAttributeValue> stringAttributeValues5 = new ArrayList<StringAttributeValue>();
        stringAttributeValues5.add(new StringAttributeValue("value5"));
        attribute5.setValues(stringAttributeValues5);
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        AttributeContext attributeCtx = new AttributeContext();
        ArrayList<IdPAttribute> attributes = new ArrayList<IdPAttribute>();
        attributes.add(attribute1);
        attributes.add(attribute2);
        attributes.add(attribute3);
        attributes.add(attribute4);
        attributes.add(attribute5);
        attributeCtx.setIdPAttributes(attributes);
        ((RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attributeCtx);
    }

    @Test
    public void testNoAttributeCtx() throws ComponentInitializationException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testNoIdToken() throws ComponentInitializationException, ParseException {
        this.setAttributeContext();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testSuccessNoConsent() throws ComponentInitializationException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        this.setAttributeContext();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("test1").equals("value1 value2"));
        Assert.assertNull((Object)this.respCtx.getIDToken().getClaim("test2"));
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("test3claim").equals("value3"));
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("test4claim").equals("value4"));
        Assert.assertNull((Object)this.respCtx.getIDToken().getClaim("test5claim"));
    }

    @Test
    public void testSuccessNoConsentWithTest2Request() throws ComponentInitializationException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        HashMultimap map = HashMultimap.create();
        map.put((Object)"test2", (Object)new IdPAttribute("test2"));
        AttributesMapContainer container = new AttributesMapContainer((Multimap)map);
        this.respCtx.setMappedIdTokenRequestedClaims(container);
        this.setAttributeContext();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("test1").equals("value1 value2"));
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("test2").equals("value"));
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("test3claim").equals("value3"));
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("test4claim").equals("value4"));
        Assert.assertNull((Object)this.respCtx.getIDToken().getClaim("test5claim"));
    }

    @Test
    public void testSuccessConsent() throws ComponentInitializationException, ParseException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        this.setAttributeContext();
        OIDCAuthenticationResponseConsentContext ctx = (OIDCAuthenticationResponseConsentContext)this.respCtx.addSubcontext((BaseContext)new OIDCAuthenticationResponseConsentContext());
        ctx.getConsentedAttributes().add((Object)"test1");
        ctx.getConsentedAttributes().add((Object)"test4");
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("test1").equals("value1 value2"));
        Assert.assertNull((Object)this.respCtx.getIDToken().getClaim("test2"));
        Assert.assertNull((Object)this.respCtx.getIDToken().getClaim("test3claim"));
        Assert.assertTrue((boolean)this.respCtx.getIDToken().getClaim("test4claim").equals("value4"));
        Assert.assertNull((Object)this.respCtx.getIDToken().getClaim("test5claim"));
    }
}

