/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddApplicationTypeToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddApplicationTypeToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    AddApplicationTypeToClientMetadata action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddApplicationTypeToClientMetadata();
        this.action.initialize();
    }

    @Test
    public void testDefault() throws ComponentInitializationException {
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(new OIDCClientMetadata(), result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)result.getApplicationType(), (Object)ApplicationType.getDefault());
    }

    @Test
    public void testWeb() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setApplicationType(ApplicationType.WEB);
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(input, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)result.getApplicationType(), (Object)ApplicationType.WEB);
    }

    @Test
    public void testNative() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setApplicationType(ApplicationType.NATIVE);
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(input, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)result.getApplicationType(), (Object)ApplicationType.NATIVE);
    }

    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        return new AddApplicationTypeToClientMetadata();
    }
}

