/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.client.RegistrationError;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcFlowTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import org.opensaml.storage.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RegistrationFlowTest
extends AbstractOidcFlowTest {
    public static final String FLOW_ID = "oidc/register";
    private final String redirectUri = "https://example.org/cb";
    private String rpId;
    private String clientId;
    @Autowired
    @Qualifier(value="shibboleth.StorageService")
    StorageService storageService;

    public RegistrationFlowTest() {
        super(FLOW_ID);
    }

    @BeforeMethod
    public void setUp() {
        this.rpId = "mockRpId";
        this.clientId = null;
    }

    @AfterMethod
    public void tearDown() throws IOException {
        if (this.clientId != null) {
            this.storageService.delete("oidcClientInformation", this.clientId);
        }
    }

    @Test
    public void testInvalidMessage() throws Exception {
        this.setJsonRequest("POST", "{ \"test\":not_json");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client_metadata");
    }

    @Test
    public void testUnauthenticated_nonCompliantWithProfilePolicy1() {
        this.setJsonRequest("POST", "{ \"redirect_uris\":[\"https://not.compliant.org/cb\"] }");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client_metadata");
    }

    @Test
    public void testUnauthenticated_nonCompliantWithProfilePolicy2() {
        this.setJsonRequest("POST", "{ \"redirect_uris\":[\"https://example.org/cb\"], \"id_token_signed_response_alg\":\"HS256\" }");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client_metadata");
    }

    @Test
    public void testUnauthenticated_success() throws Exception {
        this.setJsonRequest("POST", "{ \"redirect_uris\":[\"https://example.org/cb\"] }");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCClientInformationResponse parsedResponse = this.parseSuccessResponse(result, OIDCClientInformationResponse.class);
        OIDCClientInformation clientInfo = parsedResponse.getOIDCClientInformation();
        OIDCClientMetadata metadata = clientInfo.getOIDCMetadata();
        String record = this.storageService.read("oidcClientInformation", clientInfo.getID().toString()).getValue();
        Assert.assertNotNull((Object)record);
        JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        OIDCClientInformation storedInfo = OIDCClientInformation.parse((JSONObject)((JSONObject)parser.parse(record)));
        Assert.assertEquals((Object)storedInfo.getID(), (Object)clientInfo.getID());
        Assert.assertEquals((Object)storedInfo.getSecret(), (Object)clientInfo.getSecret());
        Assert.assertEquals((Set)storedInfo.getOIDCMetadata().getRedirectionURIStrings(), (Set)metadata.getRedirectionURIStrings());
        Assert.assertTrue((boolean)metadata.getRedirectionURIStrings().contains("https://example.org/cb"));
    }

    @Test
    public void testAccessToken_nonCompliantWithProfilePolicy1() throws Exception {
        this.setJsonRequest("POST", "{ \"redirect_uris\":[\"https://example.org/cb\"] }");
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, "[\"https://invalid.domain.org/cb\"]", new String[0]).toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, RegistrationError.INVALID_CLIENT_METADATA.getCode());
    }

    @Test
    public void testAccessToken_nonCompliantWithProfilePolicy2() throws Exception {
        this.setJsonRequest("POST", "{ \"redirect_uris\":[\"https://example.org/cb\"], \"id_token_signed_response_alg\":\"HS256\" }");
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, "[\"https://example.org/cb\"]", new String[0]).toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, RegistrationError.INVALID_CLIENT_METADATA.getCode());
    }

    @Test
    public void testAccessToken_success() throws Exception {
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb"));
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, "[\"https://example.org/cb\"]", new String[0]).toAuthorizationHeader());
        this.assertSuccessfulResponse(this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext), null);
    }

    @Test
    public void testAccessToken_success_withClientID() throws Exception {
        this.clientId = "https://example.org";
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb"));
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(true, "[\"https://example.org/cb\"]", new String[0]).toAuthorizationHeader());
        this.assertSuccessfulResponse(this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext), this.clientId);
    }

    @Test
    public void testAccessToken_successReplace() throws Exception {
        this.clientId = "https://example.org";
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb"));
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, "[\"https://example.org/cb\"]", new String[0]).toAuthorizationHeader());
        this.assertSuccessfulResponse(this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext), null);
        this.initializeMocks();
        this.initializeThreadLocals();
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb"));
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(true, "[\"https://example.org/cb\"]", new String[0]).toAuthorizationHeader());
        this.assertSuccessfulResponse(this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext), null);
    }

    @Test
    public void testAccessToken_NoReplace() throws Exception {
        this.clientId = "https://example.org";
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb"));
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, "[\"https://example.org/cb\"]", new String[0]).toAuthorizationHeader());
        this.assertSuccessfulResponse(this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext), null);
        this.initializeMocks();
        this.initializeThreadLocals();
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb"));
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, "[\"https://example.org/cb\"]", new String[0]).toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "server_error");
    }

    @Test
    public void testAccessToken_successCustomClaimIgnored() throws Exception {
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb", "\"customClaim\":\"customValue\""));
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, "[\"https://example.org/cb\"]", new String[0]).toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertSuccessfulResponse(result, null);
        OIDCClientInformationResponse parsedResponse = this.parseSuccessResponse(result, OIDCClientInformationResponse.class);
        Assert.assertNull((Object)parsedResponse.getOIDCClientInformation().getOIDCMetadata().getCustomField("customClaim"));
    }

    @Test
    public void testAccessToken_successCustomClaimInPolicyAdded() throws Exception {
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb", "\"customClaim\":\"customValue\""));
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, "[\"https://example.org/cb\"]", "customClaim").toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertSuccessfulResponse(result, null);
        OIDCClientInformationResponse parsedResponse = this.parseSuccessResponse(result, OIDCClientInformationResponse.class);
        Assert.assertEquals((Object)parsedResponse.getOIDCClientInformation().getOIDCMetadata().getCustomField("customClaim"), (Object)"customValue");
    }

    @Test
    public void testAccessToken_noPolicyNoRedirectUri() throws Exception {
        this.setJsonRequest("POST", "{ \"test\":false }");
        this.rpId = "mockDynRegClientNoProfilePolicy";
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, null, null).toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, RegistrationError.INVALID_REDIRECT_URI.getCode());
    }

    @Test
    public void testAccessToken_nonDefaultPolicyActive_failsWhenIncompatibleRequest() throws Exception {
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb", "\"grant_types\":[\"authorization_code\"]"));
        this.rpId = "mockDynRegClientAnotherProfilePolicy";
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, null, null).toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client_metadata");
    }

    @Test
    public void testAccessToken_nonDefaultPolicyActive_successWithCompatibleRequest() throws Exception {
        this.setJsonRequest("POST", this.buildRequestMessage("https://example.org/cb", "\"grant_types\":[\"implicit\"]"));
        this.rpId = "mockDynRegClientAnotherProfilePolicy";
        this.request.addHeader("Authorization", (Object)this.buildRegistrationAccessToken(false, null, null).toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertSuccessfulResponse(result, null);
        OIDCClientInformationResponse parsedResponse = this.parseSuccessResponse(result, OIDCClientInformationResponse.class);
        Assert.assertTrue((boolean)parsedResponse.getOIDCClientInformation().getOIDCMetadata().getGrantTypes().contains(GrantType.IMPLICIT));
    }

    protected void assertSuccessfulResponse(FlowExecutionResult result, String clientId) throws Exception {
        OIDCClientInformationResponse parsedResponse = this.parseSuccessResponse(result, OIDCClientInformationResponse.class);
        OIDCClientInformation clientInfo = OIDCClientInformation.parse((JSONObject)parsedResponse.getOIDCClientInformation().toJSONObject());
        OIDCClientMetadata metadata = clientInfo.getOIDCMetadata();
        if (clientId != null) {
            Assert.assertEquals((String)clientId, (String)clientInfo.getID().getValue());
        } else {
            Assert.assertNotEquals((Object)clientId, (Object)clientInfo.getID().getValue());
        }
        String record = this.storageService.read("oidcClientInformation", clientInfo.getID().toString()).getValue();
        Assert.assertNotNull((Object)record);
        JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        OIDCClientInformation storedInfo = OIDCClientInformation.parse((JSONObject)((JSONObject)parser.parse(record)));
        OIDCClientMetadata storedMetadata = storedInfo.getOIDCMetadata();
        Assert.assertEquals((Object)storedInfo.getID(), (Object)clientInfo.getID());
        Assert.assertEquals((Object)storedInfo.getSecret(), (Object)clientInfo.getSecret());
        Assert.assertEquals((Set)storedMetadata.getRedirectionURIStrings(), (Set)metadata.getRedirectionURIStrings());
        Assert.assertTrue((boolean)metadata.getRedirectionURIStrings().contains("https://example.org/cb"));
        Assert.assertEquals((int)metadata.getPolicyURIEntries().size(), (int)2);
        try {
            Assert.assertEquals((Object)metadata.getPolicyURI(LangTag.parse((String)"fi")), (Object)new URI("https://policy.org/finnish"));
            Assert.assertEquals((Object)metadata.getPolicyURI(LangTag.parse((String)"en")), (Object)new URI("https://policy.org/english"));
        }
        catch (LangTagException | URISyntaxException e) {
            Assert.fail();
        }
        Assert.assertEquals((Map)storedMetadata.getPolicyURIEntries(), (Map)metadata.getPolicyURIEntries());
        Assert.assertNull((Object)clientInfo.getSecret().getExpirationDate());
    }

    protected BearerAccessToken buildRegistrationAccessToken(boolean replacement, String redirectUriSubset, String ... additionalPolicyClaims) throws Exception {
        StringBuilder metadata = new StringBuilder();
        if (additionalPolicyClaims != null) {
            for (int i = 0; i < additionalPolicyClaims.length; ++i) {
                metadata.append("\"" + additionalPolicyClaims[i] + "\":{}");
                if (i + 1 >= additionalPolicyClaims.length) continue;
                metadata.append(",");
            }
        }
        if (redirectUriSubset != null) {
            if (metadata.length() > 0) {
                metadata.append(",");
            }
            metadata.append("\"redirect_uris\":{\"subset_of\":" + redirectUriSubset + "}");
        }
        String json = "{\"prncpl\":\"jdoe\",\"type\":\"rat\",\"exp\":" + Instant.now().plusSeconds(30L).getEpochSecond() + ",\"iat\":" + Instant.now().getEpochSecond() + ",\"jti\":\"" + this.idGenerator.generateIdentifier() + "\",\"rp_id\":\"" + this.rpId + "\"," + (String)(this.clientId != null ? "\"client_id\":\"" + this.clientId + "\"," : "") + "\"replacement\":" + Boolean.toString(replacement) + ",\"metadata\":" + (String)(metadata.length() == 0 ? "null" : "{" + metadata.toString()) + "}}";
        return new BearerAccessToken(BaseOIDCResponseActionTest.initializeDataSealer().wrap(json, Instant.now().plusSeconds(30L)));
    }

    protected String buildRequestMessage(String redirectUri) {
        return this.buildRequestMessage(redirectUri, null);
    }

    protected String buildRequestMessage(String redirectUri, String customPart) {
        StringBuilder result = new StringBuilder("{ \"redirect_uris\":[\"" + redirectUri + "\"],").append("\"policy_uri#en\":\"https://policy.org/english\",").append("\"policy_uri#fi\":\"https://policy.org/finnish\"");
        if (customPart == null) {
            return result.append("}").toString();
        }
        return result.append("," + customPart + "}").toString();
    }
}

