/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcFlowTest;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.oidc.profile.core.OidcError;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.storage.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthorizeFlowTest
extends AbstractOidcFlowTest {
    public static final String FLOW_ID = "oidc/authorize";
    String resource = "https://resource.example.org";
    String issuer = "https://op.example.org";
    String redirectUri = "https://example.org/cb";
    String clientId = "mockClientId";
    String clientIdIssInResponse = "mockClientIdIssInResponse";
    String clientIdCustomTokens = "mockClientIdCustomTokens";
    String clientSecret = "mockClientSecretmockClientSecretmockClientSecretmockClientSecretmockClientSecret";
    Scope scope = Scope.parse((String)"openid profile email");
    @Autowired
    @Qualifier(value="shibboleth.StorageService")
    StorageService storageService;

    public AuthorizeFlowTest() {
        super(FLOW_ID);
    }

    @BeforeMethod
    public void setup() {
        this.setBasicAuth("jdoe", "changeit");
    }

    @Test
    public void testWithAuthorizationCodeFlow() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithAuthorizationCodeFlowAndResource() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&resource=" + this.resource + "&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithAuthorizationCodeFlowIssInResponse() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdIssInResponse&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientIdIssInResponse, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNotNull((Object)successResponse.getIssuer());
        Assert.assertEquals((String)successResponse.getIssuer().getValue(), (String)this.issuer);
    }

    @Test
    public void testWithAuthorizationCodeFlowNoOpenid() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)"ErrorView", (String)result.getOutcome().getId());
    }

    @Test
    public void testWithImplicitFlowNoNonce() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=id_token&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)"ErrorView", (String)result.getOutcome().getId());
    }

    @Test
    public void testWithImplicitFlow() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=id_token&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithImplicitFlowIssInResponse() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdIssInResponse&response_type=id_token&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientIdIssInResponse, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNotNull((Object)successResponse.getIssuer());
        Assert.assertEquals((String)successResponse.getIssuer().getValue(), (String)this.issuer);
    }

    @Test
    public void testWithImplicitFlowAndResource() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=id_token&scope=openid%20profile&resource=" + this.resource + "&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithImplicitTokenFlow() throws IOException, SessionException, DataSealerException, java.text.ParseException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=id_token+token&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNotNull((Object)successResponse.getAccessToken());
        Assert.assertNull((Object)successResponse.getAuthorizationCode());
        AccessTokenClaimsSet token = AccessTokenClaimsSet.parse((String)successResponse.getAccessToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertEquals((Collection)token.getAudience(), Collections.singletonList(this.issuer));
        Assert.assertNull((Object)token.getClaimsSet().getStringClaim("eduPersonScopedAffiliation"));
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithImplicitTokenFlowIssInResponse() throws IOException, SessionException, DataSealerException, java.text.ParseException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdIssInResponse&response_type=id_token+token&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientIdIssInResponse, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNotNull((Object)successResponse.getAccessToken());
        Assert.assertNull((Object)successResponse.getAuthorizationCode());
        AccessTokenClaimsSet token = AccessTokenClaimsSet.parse((String)successResponse.getAccessToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertEquals((Collection)token.getAudience(), Collections.singletonList(this.issuer));
        Assert.assertNull((Object)token.getClaimsSet().getStringClaim("eduPersonScopedAffiliation"));
        Assert.assertNotNull((Object)successResponse.getIssuer());
        Assert.assertEquals((String)successResponse.getIssuer().getValue(), (String)this.issuer);
    }

    @Test
    public void testWithImplicitTokenFlowAndResource() throws IOException, SessionException, java.text.ParseException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=id_token+token&scope=openid%20profile&resource=" + this.resource + "&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNotNull((Object)successResponse.getAccessToken());
        Assert.assertNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        JWTClaimsSet token = SignedJWT.parse((String)successResponse.getAccessToken().getValue()).getJWTClaimsSet();
        Assert.assertEquals((Collection)token.getAudience(), List.of(this.resource, this.issuer));
        Assert.assertNotNull((Object)token.getStringClaim("eduPersonScopedAffiliation"));
    }

    @Test
    public void testWithImplicitTokenFlowNoNonce() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=id_token+token&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)"ErrorView", (String)result.getOutcome().getId());
    }

    @Test
    public void testWithImplicitFlowNoOpenIdScope() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=id_token&scope=profile&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)"ErrorView", (String)result.getOutcome().getId());
    }

    @Test
    public void testWithHybridIdTokenFlow() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code+id_token&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithHybridIdTokenFlowIssInResponse() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdIssInResponse&response_type=code+id_token&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientIdIssInResponse, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNotNull((Object)successResponse.getIssuer());
        Assert.assertEquals((String)successResponse.getIssuer().getValue(), (String)this.issuer);
    }

    @Test
    public void testWithHybridIdTokenFlowAndResource() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code+id_token&scope=openid%20profile&resource=" + this.resource + "&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithHybridIdTokenFlowNoNonce() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code+id_token&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)"ErrorView", (String)result.getOutcome().getId());
    }

    @Test
    public void testWithHybridTokenFlow() throws IOException, SessionException, java.text.ParseException, DataSealerException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code+token&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNotNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        AccessTokenClaimsSet token = AccessTokenClaimsSet.parse((String)successResponse.getAccessToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertEquals((Collection)token.getAudience(), Collections.singletonList(this.issuer));
        Assert.assertNull((Object)token.getClaimsSet().getStringClaim("eduPersonScopedAffiliation"));
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithHybridTokenFlowAndResource() throws IOException, SessionException, java.text.ParseException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code+token&scope=openid%20profile&resource=" + this.resource + "&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNotNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        JWTClaimsSet token = SignedJWT.parse((String)successResponse.getAccessToken().getValue()).getJWTClaimsSet();
        Assert.assertEquals((Collection)token.getAudience(), List.of(this.resource, this.issuer));
        Assert.assertNotNull((Object)token.getStringClaim("eduPersonScopedAffiliation"));
    }

    @Test
    public void testWithHybridIdTokenTokenFlow() throws IOException, SessionException, java.text.ParseException, DataSealerException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code+id_token+token&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNotNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        AccessTokenClaimsSet token = AccessTokenClaimsSet.parse((String)successResponse.getAccessToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertEquals((Collection)token.getAudience(), Collections.singletonList(this.issuer));
        Assert.assertNull((Object)token.getClaimsSet().getStringClaim("eduPersonScopedAffiliation"));
    }

    @Test
    public void testWithHybridIdTokenTokenFlowWithCustomTokenClaim() throws IOException, SessionException, java.text.ParseException, DataSealerException, ParseException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdCustomTokens&response_type=code+id_token+token&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientIdCustomTokens, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNotNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        IDTokenClaimsSet idToken = new IDTokenClaimsSet(successResponse.getIDToken().getJWTClaimsSet());
        Assert.assertNotNull((Object)idToken);
        Assert.assertNotNull((Object)idToken.getStringClaim("custom_id_token_claim"));
        Assert.assertEquals((String)idToken.getStringClaim("custom_id_token_claim"), (String)"value1");
        AccessTokenClaimsSet token = AccessTokenClaimsSet.parse((String)successResponse.getAccessToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertEquals((Collection)token.getAudience(), Collections.singletonList(this.issuer));
        Assert.assertNull((Object)token.getClaimsSet().getStringClaim("eduPersonScopedAffiliation"));
        String customClaim = token.getClaimsSet().getStringClaim("custom_access_token_claim");
        Assert.assertNotNull((Object)customClaim);
        Assert.assertEquals((String)customClaim, (String)"value2");
    }

    @Test
    public void testWithHybridIdTokenTokenFlowAndResource() throws IOException, SessionException, java.text.ParseException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code+id_token+token&scope=openid%20profile&resource=" + this.resource + "&redirect_uri=" + this.redirectUri + "&nonce=idhas3h23hi13h1o2i32");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNotNull((Object)successResponse.getIDToken());
        Assert.assertNotNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        JWTClaimsSet token = SignedJWT.parse((String)successResponse.getAccessToken().getValue()).getJWTClaimsSet();
        Assert.assertEquals((Collection)token.getAudience(), List.of(this.resource, this.issuer));
        Assert.assertNotNull((Object)token.getStringClaim("eduPersonScopedAffiliation"));
    }

    @Test
    public void testWithHybridIdTokenTokenFlowNoNonce() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code+id_token+token&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)"ErrorView", (String)result.getOutcome().getId());
    }

    @Test
    public void testWithAuthorizationCodeFlowUnforcedPKCE() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdPKCEPlainUnforced&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, "mockClientIdPKCEPlainUnforced", this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
    }

    @Test
    public void testWithAuthorizationCodeFlowForcedPlainPKCEMissingChallenge() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdPKCEPlain&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, "mockClientIdPKCEPlain", this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, OidcError.MISSING_PKCE_CODE_CHALLENGE.getDescription());
    }

    @Test
    public void testWithAuthorizationCodeFlowForcedPlainPKCEUnknownChallenge() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdPKCEPlain&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&code_challenge=osdfojsfod&code_challenge_method=unsupported");
        this.storeMetadata(this.storageService, "mockClientIdPKCEPlain", this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, OidcError.INVALID_PKCE_TRANSFORMATION_METHOD.getDescription());
    }

    @Test
    public void testWithAuthorizationCodeFlowForcedPlainPKCEValidChallenge() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdPKCEPlain&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&code_challenge=osdfojsfod&code_challenge_method=plain");
        this.storeMetadata(this.storageService, "mockClientIdPKCEPlain", this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
    }

    @Test
    public void testWithAuthorizationCodeFlowForcedS256PKCEPlainChallenge() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdPKCES256&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&code_challenge=osdfojsfod&code_challenge_method=plain");
        this.storeMetadata(this.storageService, "mockClientIdPKCES256", this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, OidcError.INVALID_PKCE_TRANSFORMATION_METHOD.getDescription());
    }

    @Test
    public void testWithAuthorizationCodeFlowForcedS256PKCEUnknownChallenge() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdPKCES256&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&code_challenge=osdfojsfod&code_challenge_method=unknown");
        this.storeMetadata(this.storageService, "mockClientIdPKCES256", this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, OidcError.INVALID_PKCE_TRANSFORMATION_METHOD.getDescription());
    }

    @Test
    public void testWithAuthorizationCodeFlowForcedS256PKCEValidChallenge() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdPKCES256&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&code_challenge=osdfojsfod&code_challenge_method=S256");
        this.storeMetadata(this.storageService, "mockClientIdPKCES256", this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
    }

    @Test
    public void testWithAuthorizationCodeFlowNoScopes() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, null, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "InvalidSubject");
        this.assertErrorResponseWithNoIssuer(result);
    }

    @Test
    public void testWithAuthorizationCodeFlowNoScopesIssInResponse() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdIssInResponse&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientIdIssInResponse, this.clientSecret, null, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "InvalidSubject");
        this.assertErrorResponseWithIssuer(result);
    }

    @Test
    public void testWithAuthorizationCodeFlowWithIDTokenClaims() throws IOException, SessionException, DataSealerException, java.text.ParseException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&claims=%7B%22id_token%22%3A%7B%22email%22%3A%7B%22essential%22%3Atrue%7D%7D%7D&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        AuthorizeCodeClaimsSet code = AuthorizeCodeClaimsSet.parse((String)successResponse.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)code.getClaimsRequest());
        Assert.assertNotNull((Object)code.getClaimsRequest().getIDTokenClaimsRequest());
        Assert.assertNull((Object)code.getClaimsRequest().getUserInfoClaimsRequest());
        Assert.assertTrue((boolean)code.getClaimsRequest().getIDTokenClaimsRequest().getClaimNames(false).contains("email"));
        ClaimsSetRequest.Entry email = code.getClaimsRequest().getIDTokenClaimsRequest().get("email", null);
        Assert.assertEquals((String)email.getClaimName(), (String)"email");
        Assert.assertEquals((Object)email.getClaimRequirement(), (Object)ClaimRequirement.ESSENTIAL);
    }

    @Test
    public void testWithAuthorizationCodeFlowWithUIClaims() throws IOException, SessionException, DataSealerException, java.text.ParseException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&claims=%7B%22userinfo%22%3A%7B%22email%22%3A%7B%22essential%22%3Atrue%7D%7D%7D&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        AuthorizeCodeClaimsSet code = AuthorizeCodeClaimsSet.parse((String)successResponse.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)code.getClaimsRequest());
        Assert.assertNull((Object)code.getClaimsRequest().getIDTokenClaimsRequest());
        Assert.assertNotNull((Object)code.getClaimsRequest().getUserInfoClaimsRequest());
        Assert.assertTrue((boolean)code.getClaimsRequest().getUserInfoClaimsRequest().getClaimNames(false).contains("email"));
        ClaimsSetRequest.Entry email = code.getClaimsRequest().getUserInfoClaimsRequest().get("email", null);
        Assert.assertEquals((String)email.getClaimName(), (String)"email");
        Assert.assertEquals((Object)email.getClaimRequirement(), (Object)ClaimRequirement.ESSENTIAL);
    }

    @Test
    public void testWithAuthorizationCodeFlowWithCustomClaimInCode() throws IOException, SessionException, DataSealerException, java.text.ParseException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientIdCustomTokens&response_type=code&scope=openid%20profile&claims=%7B%22userinfo%22%3A%7B%22email%22%3A%7B%22essential%22%3Atrue%7D%7D%7D&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientIdCustomTokens, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        AuthorizeCodeClaimsSet code = AuthorizeCodeClaimsSet.parse((String)successResponse.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Object customClaim = code.getClaimsSet().getClaim("custom_code_claim");
        Assert.assertNotNull((Object)customClaim);
        Assert.assertEquals((Object)customClaim, (Object)"value1");
    }

    @Test
    public void testWithAuthorizationCodeFlowUsingSAMLMetadata() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockSamlClientId&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithAuthorizationCodeFlowUsingUntrustedRP() throws IOException, SessionException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=notTrusted&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertFlowExecutionResult(result, FLOW_ID);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ErrorView");
    }

    @Test
    public void testWithPlainReqObjectExpired() throws IOException, SessionException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().expirationTime(Date.from(Instant.now().minus(Duration.ofMinutes(5L)))).build();
        this.assertRequestObjectError((JWT)new PlainJWT(ro));
    }

    @Test
    public void testWithPlainReqObjectNbfInFuture() throws IOException, SessionException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().notBeforeTime(Date.from(Instant.now().plus(Duration.ofMinutes(5L)))).build();
        this.assertRequestObjectError((JWT)new PlainJWT(ro));
    }

    @Test
    public void testWithPlainReqObjectOverwriteRedirectUri() throws IOException, SessionException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("redirect_uri", (Object)this.redirectUri).build();
        PlainJWT requestObject = new PlainJWT(ro);
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&redirect_uri=https://invalid.org/cb&request=" + requestObject.serialize());
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithPlainReqObjectClaimsRequest() throws IOException, SessionException, DataSealerException, java.text.ParseException {
        String payload = "{\n  \"iss\": \"" + this.clientId + "\",\n  \"response_type\": \"code\",\n  \"code_challenge_method\": \"S256\",\n  \"nonce\": \"k5r-Uwjw0KKr18XiKD2VbiLtD2adwt85_HiSvzBi8FI\",\n  \"client_id\": \"" + this.clientId + "\",\n  \"aud\": \"https://op.example.org\",\n  \"scope\": \"openid profile offline_access\",\n  \"claims\": {\n    \"id_token\": {\n      \"given_name\": {\n        \"essential\": true\n      }\n    },\n    \"userinfo\": {\n      \"family_name\": {\n        \"essential\": true\n      }\n    }\n  },\n  \"redirect_uri\": \"" + this.redirectUri + "\",\n  \"state\": \"81c33d57-59c7-4b41-9a15-80e2ed1482e21646857349537\",\n  \"code_challenge\": \"MiAR-UxCj6oVyPatcUnrb3MGEZbwLKBmIRSoOKLLTl0\"\n}";
        JWTClaimsSet ro = JWTClaimsSet.parse((String)payload);
        PlainJWT requestObject = new PlainJWT(ro);
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&redirect_uri=https://invalid.org/cb&request=" + requestObject.serialize());
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        AuthorizeCodeClaimsSet code = AuthorizeCodeClaimsSet.parse((String)successResponse.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)code.getClaimsRequest());
        Assert.assertNotNull((Object)code.getClaimsRequest().getIDTokenClaimsRequest());
        Assert.assertNotNull((Object)code.getClaimsRequest().getUserInfoClaimsRequest());
        Assert.assertTrue((boolean)code.getClaimsRequest().getUserInfoClaimsRequest().getClaimNames(false).contains("family_name"));
        Assert.assertTrue((boolean)code.getClaimsRequest().getIDTokenClaimsRequest().getClaimNames(false).contains("given_name"));
        ClaimsSetRequest.Entry familyName = code.getClaimsRequest().getUserInfoClaimsRequest().get("family_name", null);
        Assert.assertEquals((String)familyName.getClaimName(), (String)"family_name");
        Assert.assertEquals((Object)familyName.getClaimRequirement(), (Object)ClaimRequirement.ESSENTIAL);
        ClaimsSetRequest.Entry givenName = code.getClaimsRequest().getIDTokenClaimsRequest().get("given_name", null);
        Assert.assertEquals((String)givenName.getClaimName(), (String)"given_name");
        Assert.assertEquals((Object)givenName.getClaimRequirement(), (Object)ClaimRequirement.ESSENTIAL);
    }

    @Test
    public void testWithSignedReqObjectNoIssuer() throws IOException, SessionException, JOSEException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().audience(this.issuer).build();
        this.assertRequestObjectError((JWT)AuthorizeFlowTest.createSecretJWT(ro, this.clientSecret));
    }

    @Test
    public void testWithSignedReqObjectNoAudience() throws IOException, SessionException, JOSEException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().issuer(this.clientId).build();
        this.assertRequestObjectError((JWT)AuthorizeFlowTest.createSecretJWT(ro, this.clientSecret));
    }

    @Test
    public void testWithSignedReqObjectWrongIssuer() throws IOException, SessionException, JOSEException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().audience(this.issuer).issuer("invalid").build();
        this.assertRequestObjectError((JWT)AuthorizeFlowTest.createSecretJWT(ro, this.clientSecret));
    }

    @Test
    public void testWithSignedReqObjectWrongAudience() throws IOException, SessionException, JOSEException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().audience("https://invalid.org").issuer(this.clientId).build();
        this.assertRequestObjectError((JWT)AuthorizeFlowTest.createSecretJWT(ro, this.clientSecret));
    }

    @Test
    public void testWithSignedReqObjectOverwriteRedirectUri() throws IOException, java.text.ParseException, SessionException, JOSEException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().audience(this.issuer).issuer(this.clientId).claim("redirect_uri", (Object)this.redirectUri).build();
        SignedJWT requestObject = AuthorizeFlowTest.createSecretJWT(ro, this.clientSecret);
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&redirect_uri=https://invalid.org/cb&request=" + requestObject.serialize());
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
    }

    @Test
    public void testWithSignedReqObjectClaimsRequest() throws IOException, SessionException, JOSEException, DataSealerException, java.text.ParseException {
        String payload = "{\n  \"iss\": \"" + this.clientId + "\",\n  \"response_type\": \"code\",\n  \"code_challenge_method\": \"S256\",\n  \"nonce\": \"k5r-Uwjw0KKr18XiKD2VbiLtD2adwt85_HiSvzBi8FI\",\n  \"client_id\": \"" + this.clientId + "\",\n  \"aud\": \"https://op.example.org\",\n  \"scope\": \"openid profile offline_access\",\n  \"claims\": {\n    \"id_token\": {\n      \"given_name\": {\n        \"essential\": true\n      }\n    },\n    \"userinfo\": {\n      \"family_name\": {\n        \"essential\": true\n      }\n    }\n  },\n  \"redirect_uri\": \"" + this.redirectUri + "\",\n  \"state\": \"81c33d57-59c7-4b41-9a15-80e2ed1482e21646857349537\",\n  \"code_challenge\": \"MiAR-UxCj6oVyPatcUnrb3MGEZbwLKBmIRSoOKLLTl0\"\n}";
        JWTClaimsSet ro = JWTClaimsSet.parse((String)payload);
        SignedJWT requestObject = AuthorizeFlowTest.createSecretJWT(ro, this.clientSecret);
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&request=" + requestObject.serialize());
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AuthenticationResponse responseMessage = this.parseSuccessResponse(result, AuthenticationResponse.class);
        AuthenticationSuccessResponse successResponse = responseMessage.toSuccessResponse();
        Assert.assertEquals((String)successResponse.getRedirectionURI().toString(), (String)this.redirectUri);
        Assert.assertNull((Object)successResponse.getIDToken());
        Assert.assertNull((Object)successResponse.getAccessToken());
        Assert.assertNotNull((Object)successResponse.getAuthorizationCode());
        Assert.assertNull((Object)successResponse.getIssuer());
        AuthorizeCodeClaimsSet code = AuthorizeCodeClaimsSet.parse((String)successResponse.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)code.getClaimsRequest());
        Assert.assertNotNull((Object)code.getClaimsRequest().getIDTokenClaimsRequest());
        Assert.assertNotNull((Object)code.getClaimsRequest().getUserInfoClaimsRequest());
        Assert.assertTrue((boolean)code.getClaimsRequest().getUserInfoClaimsRequest().getClaimNames(false).contains("family_name"));
        Assert.assertTrue((boolean)code.getClaimsRequest().getIDTokenClaimsRequest().getClaimNames(false).contains("given_name"));
        ClaimsSetRequest.Entry familyName = code.getClaimsRequest().getUserInfoClaimsRequest().get("family_name", null);
        Assert.assertEquals((String)familyName.getClaimName(), (String)"family_name");
        Assert.assertEquals((Object)familyName.getClaimRequirement(), (Object)ClaimRequirement.ESSENTIAL);
        ClaimsSetRequest.Entry givenName = code.getClaimsRequest().getIDTokenClaimsRequest().get("given_name", null);
        Assert.assertEquals((String)givenName.getClaimName(), (String)"given_name");
        Assert.assertEquals((Object)givenName.getClaimRequirement(), (Object)ClaimRequirement.ESSENTIAL);
    }

    protected void assertRequestObjectError(JWT requestObject) throws IOException {
        this.request.setMethod("GET");
        this.request.setQueryString("client_id=mockClientId&response_type=code&scope=openid%20profile&redirect_uri=" + this.redirectUri + "&request=" + requestObject.serialize());
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, this.redirectUri);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertFlowExecutionResult(result, FLOW_ID);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ErrorView");
    }

    protected void assertErrorResponseWithNoIssuer(FlowExecutionResult result) {
        Response response = this.parseResponse(result);
        Assert.assertFalse((boolean)response.indicatesSuccess());
        Assert.assertTrue((boolean)(response instanceof AuthenticationErrorResponse));
        AuthenticationErrorResponse errorResponse = (AuthenticationErrorResponse)response;
        Assert.assertNull((Object)errorResponse.getIssuer());
    }

    protected void assertErrorResponseWithIssuer(FlowExecutionResult result) {
        Response response = this.parseResponse(result);
        Assert.assertFalse((boolean)response.indicatesSuccess());
        Assert.assertTrue((boolean)(response instanceof AuthenticationErrorResponse));
        AuthenticationErrorResponse errorResponse = (AuthenticationErrorResponse)response;
        Assert.assertNotNull((Object)errorResponse.getIssuer());
        Assert.assertEquals((String)errorResponse.getIssuer().getValue(), (String)this.issuer);
    }

    @AfterMethod
    public void removeMetadata() throws IOException {
        this.removeMetadata(this.storageService, this.clientId);
        this.removeMetadata(this.storageService, "mockClientIdPKCEPlainUnforced");
        this.removeMetadata(this.storageService, "mockClientIdPKCEPlain");
        this.removeMetadata(this.storageService, "mockClientIdPKCES256");
        this.removeMetadata(this.storageService, "mockClientIdCustomTokens");
        this.removeMetadata(this.storageService, this.clientIdIssInResponse);
    }
}

