/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.AccessTokenContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.BuildAccessToken;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BuildAccessTokenTest
extends BaseOIDCResponseActionTest {
    @Nullable
    private BuildAccessToken action;

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        ((SubjectContext)this.profileRequestCtx.getSubcontext(SubjectContext.class, true)).setPrincipalName("jdoe");
        this.respCtx.setAuthTime(Instant.now());
        this.respCtx.setSubject(this.clientId);
        this.respCtx.setAcr("0");
        this.respCtx.setScope(new Scope());
        this.respCtx.getAudience().add("https://rp.example.org");
        this.action = new BuildAccessToken();
    }

    @Test
    public void testNoClientID() throws NoSuchAlgorithmException, ComponentInitializationException {
        this.action.setClientIDLookupStrategy(FunctionSupport.constant(null));
        this.action.setDataSealer(this.getDataSealer());
        this.action.initialize();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"MessageProcessingError");
    }

    @Test
    public void testOpaqueSuccess() throws ParseException, DataSealerException, ComponentInitializationException, NoSuchAlgorithmException {
        this.initAction(null, null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        this.verifyClaims((AccessTokenContext)this.respCtx.getSubcontext(AccessTokenContext.class), new Scope(), Collections.singletonList("https://rp.example.org"), null);
    }

    @Test
    public void testOpaqueSuccessWithCustomClaims() throws ParseException, DataSealerException, ComponentInitializationException, NoSuchAlgorithmException {
        this.initAction(null, prc -> (prc2, map) -> BuildAccessTokenTest.addEntryToMap(map, "custom_claim", "custom_value"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        this.verifyClaims((AccessTokenContext)this.respCtx.getSubcontext(AccessTokenContext.class), new Scope(), Collections.singletonList("https://rp.example.org"), Map.of("custom_claim", "custom_value"));
    }

    @Test
    public void testJWTSuccess() throws ParseException, ComponentInitializationException, NoSuchAlgorithmException, DataSealerException {
        this.initAction("JWT", null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        this.verifyClaims((AccessTokenContext)this.respCtx.getSubcontext(AccessTokenContext.class), new Scope(), Collections.singletonList("https://rp.example.org"), null);
    }

    @Test
    public void testJWTSuccessWithCustomClaim() throws ParseException, ComponentInitializationException, NoSuchAlgorithmException, DataSealerException {
        this.initAction("JWT", prc -> (prc2, map) -> BuildAccessTokenTest.addEntryToMap(map, "custom_claim", "custom_value"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        this.verifyClaims((AccessTokenContext)this.respCtx.getSubcontext(AccessTokenContext.class), new Scope(), Collections.singletonList("https://rp.example.org"), Map.of("custom_claim", "custom_value"));
    }

    private void initAction(@Nullable @NotEmpty String type, @Nullable Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> manipulationStrategy) throws ComponentInitializationException, NoSuchAlgorithmException {
        if ("JWT".equals(type)) {
            this.action.setAccessTokenTypeLookupStrategy(FunctionSupport.constant((Object)"JWT"));
        }
        if (manipulationStrategy != null) {
            this.action.setTokenClaimsSetManipulationStrategyLookupStrategy(manipulationStrategy);
        }
        this.action.setDataSealer(this.getDataSealer());
        this.action.setClientIDLookupStrategy(FunctionSupport.constant((Object)new ClientID(this.clientId)));
        this.action.initialize();
    }

    private void verifyClaims(@Nonnull AccessTokenContext ctx, @Nonnull Scope scope, @Nonnull @NonnullElements Collection<String> audiences, Map<String, Object> customClaims) throws NoSuchAlgorithmException, ParseException, DataSealerException, ComponentInitializationException {
        Assert.assertEquals((Object)ctx.getLifetime(), (Object)Duration.ofMinutes(10L));
        if (ctx.getOpaque() != null) {
            AccessTokenClaimsSet at = AccessTokenClaimsSet.parse((String)ctx.getOpaque(), (DataSealer)this.getDataSealer());
            Assert.assertNotNull((Object)at);
            Assert.assertEquals((String)at.getACR(), (String)"0");
            Assert.assertEquals((Collection)at.getAudience(), audiences);
            Assert.assertTrue((boolean)at.getAuthenticationTime().isBefore(Instant.now()));
            Assert.assertEquals((String)at.getClientID().getValue(), (String)this.clientId);
            Assert.assertEquals((Object)at.getExp(), (Object)at.getIssuedAt().plusSeconds(600L));
            Assert.assertEquals((String)at.getIssuer(), (String)"http://idp.example.org");
            Assert.assertTrue((boolean)at.getIssuedAt().isBefore(Instant.now()));
            Assert.assertEquals((Set)at.getScope(), (Set)scope);
            Assert.assertEquals((String)at.getSubject(), (String)this.clientId);
            Assert.assertEquals((String)at.getPrincipal(), (String)"jdoe");
            this.verifyCustomClaims(at.getClaimsSet(), customClaims);
        } else if (ctx.getJWT() != null) {
            JWTClaimsSet claims = ctx.getJWT().getJWTClaimsSet();
            Assert.assertNotNull((Object)claims);
            Assert.assertEquals((String)claims.getStringClaim("acr"), (String)"0");
            Assert.assertEquals((Collection)claims.getAudience(), audiences);
            Assert.assertTrue((boolean)claims.getDateClaim("auth_time").toInstant().isBefore(Instant.now()));
            Assert.assertEquals((String)claims.getStringClaim("client_id"), (String)this.clientId);
            Assert.assertEquals((Object)claims.getExpirationTime().toInstant(), (Object)claims.getIssueTime().toInstant().plusSeconds(600L));
            Assert.assertEquals((String)claims.getIssuer(), (String)"http://idp.example.org");
            Assert.assertTrue((boolean)claims.getIssueTime().toInstant().isBefore(Instant.now()));
            Assert.assertEquals((String)claims.getStringClaim("scope"), (String)scope.toString());
            Assert.assertEquals((String)claims.getSubject(), (String)this.clientId);
            JWTClaimsSet unsealedClaims = JWTClaimsSet.parse((String)this.getDataSealer().unwrap(claims.getStringClaim("for_op")));
            Assert.assertEquals((String)unsealedClaims.getStringClaim("prncpl"), (String)"jdoe");
            this.verifyCustomClaims(claims, customClaims);
        } else {
            throw new RuntimeException("No token found");
        }
    }

    protected void verifyCustomClaims(JWTClaimsSet claimsSet, Map<String, Object> customClaims) {
        if (customClaims == null) {
            return;
        }
        for (String claim : customClaims.keySet()) {
            Assert.assertNotNull((Object)claimsSet.getClaim(claim));
            Assert.assertEquals((Object)claimsSet.getClaim(claim), (Object)customClaims.get(claim));
        }
    }
}

