/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.HashMap;
import net.shibboleth.idp.plugin.oidc.op.metadata.impl.DynamicFilesystemProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.impl.FilesystemMetadataValueResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.impl.FilesystemProviderMetdataResolverTest;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DynamicFilesystemProviderMetadataResolverTest
extends FilesystemProviderMetdataResolverTest {
    String name;
    String value;

    @Override
    @BeforeMethod
    public void initTests() throws Exception {
        super.initTests();
        this.resolver = new DynamicFilesystemProviderMetadataResolver(this.file);
        ((DynamicFilesystemProviderMetadataResolver)this.resolver).setId("mockId");
        ((DynamicFilesystemProviderMetadataResolver)this.resolver).initialize();
        this.name = "mockName";
        this.value = "mockValue";
        FilesystemMetadataValueResolver valueResolver = new FilesystemMetadataValueResolver((Resource)new ClassPathResource("/net/shibboleth/idp/oidc/metadata/impl/dyn-value1.json"));
        valueResolver.setId("mock");
        valueResolver.initialize();
        HashMap<String, FilesystemMetadataValueResolver> map = new HashMap<String, FilesystemMetadataValueResolver>();
        map.put(this.name, valueResolver);
        ((DynamicFilesystemProviderMetadataResolver)this.resolver).setDynamicValueResolvers(map);
    }

    @Test
    public void testDynamic() throws Exception {
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)this.resolver.resolveSingle((Object)new ProfileRequestContext());
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((String)metadata.getIssuer().getValue(), (String)"http://idp.example.org");
        ((DynamicFilesystemProviderMetadataResolver)this.resolver).refresh();
        metadata = (OIDCProviderMetadata)this.resolver.resolveSingle((Object)new ProfileRequestContext());
        Assert.assertNotNull((Object)metadata.getCustomParameter(this.name));
        Assert.assertEquals((Object)metadata.getCustomParameter(this.name), (Object)this.value);
    }
}

