/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.oidc.op.authn.impl.ValidateClientAuthenticationType;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateClientAuthenticationTypeTest {
    private ClientID clientId;
    private Secret clientSecret;
    private ValidateClientAuthenticationType action;
    private RequestContext rc;
    private ProfileRequestContext prc;
    private Set<ClientAuthenticationMethod> enabledMethods;

    @BeforeMethod
    public void init() throws ComponentInitializationException {
        this.clientId = new ClientID("mockId");
        this.clientSecret = new Secret("secret1234567890secret1234567890secret1234567890");
        this.enabledMethods = Collections.emptySet();
        this.action = new ValidateClientAuthenticationType();
        this.action.setTokenEndpointAuthMethodsLookupStrategy(p -> this.enabledMethods);
        this.action.initialize();
    }

    protected void initializeRequestCtx(ClientAuthenticationMethod method, ClientAuthenticationMethod storedMethod) throws JOSEException, ComponentInitializationException {
        Object clientAuth = method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) ? new ClientSecretBasic(this.clientId, this.clientSecret) : (method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_POST) ? new ClientSecretPost(this.clientId, this.clientSecret) : null);
        this.rc = new RequestContextBuilder().setInboundMessage(null).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.prc.addSubcontext((BaseContext)new AuthenticationContext()).addSubcontext((BaseContext)new OAuth2ClientAuthenticationContext().setClientAuthentication((ClientAuthentication)clientAuth));
        OIDCMetadataContext oidcContext = new OIDCMetadataContext();
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        metadata.setTokenEndpointAuthMethod(storedMethod);
        Secret secret = new Secret("WRONG1234567890secret1234567890secret1234567890");
        OIDCClientInformation clientInformation = new OIDCClientInformation(this.clientId, new Date(), metadata, secret);
        oidcContext.setClientInformation(clientInformation);
        this.prc.getInboundMessageContext().addSubcontext((BaseContext)oidcContext);
    }

    @Test
    public void testNoAuthnContext() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        this.prc.removeSubcontext(AuthenticationContext.class);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)e, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testNoneDisabled() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.NONE, ClientAuthenticationMethod.NONE);
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).removeSubcontext(OAuth2ClientAuthenticationContext.class);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)e, (String)"AccessDenied");
    }

    @Test
    public void testNoneEnabled() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.NONE, ClientAuthenticationMethod.NONE);
        this.enabledMethods = Collections.singleton(ClientAuthenticationMethod.NONE);
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).removeSubcontext(OAuth2ClientAuthenticationContext.class);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)e);
    }

    @Test
    public void testBasicDisabled() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.NONE, ClientAuthenticationMethod.NONE);
        this.enabledMethods = Collections.singleton(ClientAuthenticationMethod.CLIENT_SECRET_POST);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)e, (String)"AccessDenied");
    }

    @Test
    public void testBasicEnabled() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        this.enabledMethods = Collections.singleton(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)e);
    }

    @Test
    public void testNoMetadata() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        this.prc.getInboundMessageContext().removeSubcontext(this.prc.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class));
        this.enabledMethods = Collections.singleton(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)e);
    }
}

