/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.impl;

import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.impl.ValidateCredentials;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.plugin.oidc.op.authn.impl.OIDCClientInfoCredentialValidator;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCClientInfoCredentialValidatorTest
extends BaseAuthenticationContextTest {
    private ClientID clientId;
    private Secret clientSecret;
    private OIDCClientInfoCredentialValidator validator;
    private ValidateCredentials action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.clientId = new ClientID("mockId");
        this.clientSecret = new Secret("secret1234567890secret1234567890secret1234567890");
        this.validator = new OIDCClientInfoCredentialValidator();
        this.validator.setId("test");
        this.validator.initialize();
        this.action = new ValidateCredentials();
        this.action.setValidators(Collections.singletonList(this.validator));
        HashMap<String, Set<String>> mappings = new HashMap<String, Set<String>>();
        mappings.put("InvalidPassword", Collections.singleton("InvalidCredentials"));
        mappings.put("UnknownUsername", Collections.singleton("UnknownUsername"));
        this.action.setClassifiedMessages(mappings);
        this.action.initialize();
        OIDCMetadataContext oidcContext = new OIDCMetadataContext();
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        Secret secret = new Secret("secret1234567890secret1234567890secret1234567890");
        OIDCClientInformation clientInformation = new OIDCClientInformation(this.clientId, new Date(), metadata, secret);
        oidcContext.setClientInformation(clientInformation);
        this.prc.getInboundMessageContext().addSubcontext((BaseContext)oidcContext);
    }

    @Test
    public void testMissingFlow() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testMissingUser() {
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingUser2() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ac.getSubcontext(UsernamePasswordContext.class, true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testBadPassword() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ((UsernamePasswordContext)ac.getSubcontext(UsernamePasswordContext.class, true)).setUsername(this.clientId.getValue()).setPassword("foo");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidPassword");
        AuthenticationErrorContext errorCtx = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertTrue((boolean)(errorCtx.getExceptions().get(0) instanceof LoginException));
        Assert.assertFalse((boolean)errorCtx.isClassifiedError("UnknownUsername"));
        Assert.assertTrue((boolean)errorCtx.isClassifiedError("InvalidPassword"));
    }

    @Test
    public void testAuthorized() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ((UsernamePasswordContext)ac.getSubcontext(UsernamePasswordContext.class, true)).setUsername(this.clientId.getValue()).setPassword(this.clientSecret.getValue());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)ac.getAuthenticationResult());
        Assert.assertEquals((String)ac.getAuthenticationResult().getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)this.clientId.getValue());
    }

    @Test
    public void testAuthorizedSHA2() throws NoSuchAlgorithmException {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        ((UsernamePasswordContext)ac.getSubcontext(UsernamePasswordContext.class, true)).setUsername(this.clientId.getValue()).setPassword(this.clientSecret.getValue());
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        Secret secret = new Secret("{SHA2}" + new StringDigester("SHA-256", StringDigester.OutputFormat.BASE64).apply(this.clientSecret.getValue()));
        OIDCClientInformation clientInformation = new OIDCClientInformation(this.clientId, new Date(), metadata, secret);
        ((OIDCMetadataContext)this.prc.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class)).setClientInformation(clientInformation);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)ac.getAuthenticationResult());
        Assert.assertEquals((String)ac.getAuthenticationResult().getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)this.clientId.getValue());
    }
}

