/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.text.ParseException;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;

public final class RefreshTokenClaimsSet
extends TokenClaimsSet {
    @Nonnull
    @NotEmpty
    private static final String VALUE_TYPE_RF = "rf";

    @Deprecated(since="3.1.0", forRemoval=true)
    public RefreshTokenClaimsSet(@Nonnull TokenClaimsSet tokenClaimsSet, @Nonnull Instant iat, @Nonnull Instant exp) {
        Builder builder = new Builder(tokenClaimsSet, iat, exp);
        this.setClaimsSet(builder.buildJWTClaimsSet(VALUE_TYPE_RF));
    }

    private RefreshTokenClaimsSet(JWTClaimsSet refreshTokenClaimsSet) {
        super(refreshTokenClaimsSet);
    }

    @Nonnull
    public static RefreshTokenClaimsSet parse(@Nonnull @NotEmpty String refreshTokenClaimsSet) throws ParseException {
        JWTClaimsSet atClaimsSet = JWTClaimsSet.parse((String)refreshTokenClaimsSet);
        RefreshTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_RF, atClaimsSet);
        return new RefreshTokenClaimsSet(atClaimsSet);
    }

    @Nonnull
    public static RefreshTokenClaimsSet parse(@Nonnull @NotEmpty String wrappedAccessToken, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        return RefreshTokenClaimsSet.parse(dataSealer.unwrap(wrappedAccessToken));
    }

    public static final class Builder
    extends TokenClaimsSet.Builder<RefreshTokenClaimsSet> {
        public Builder() {
        }

        public Builder(@Nonnull TokenClaimsSet existing, @Nonnull Instant iat, @Nonnull Instant exp) {
            this(existing);
            this.setIssuedAt(iat);
            this.setExpiresAt(exp);
        }

        private Builder(@Nonnull TokenClaimsSet existing) {
            this.setJWTID(existing.getID());
            this.setNotBefore(existing.getNotBefore());
            this.setClientID(existing.getClientID());
            this.setIssuer(existing.getClaimsSet().getIssuer());
            this.setPrincipal(existing.getPrincipal());
            this.setSubject(existing.getClaimsSet().getSubject());
            this.setACR(existing.getACR() == null ? null : new ACR(existing.getACR()));
            this.setAuthenticationTime(existing.getAuthenticationTime());
            this.setNonce(existing.getNonce());
            this.setRedirectURI(existing.getRedirectURI());
            this.setScope(existing.getScope());
            this.setClaimsRequest(existing.getClaimsRequest());
            this.setDlClaims(existing.getDeliveryClaims());
            this.setDlClaimsUI(existing.getUserinfoDeliveryClaims());
            this.setConsentedClaims(existing.getConsentedClaims());
            this.setConsentEnabled(existing.isConsentEnabled());
        }

        @Override
        @Nonnull
        public RefreshTokenClaimsSet build() {
            return new RefreshTokenClaimsSet(this.buildJWTClaimsSet(RefreshTokenClaimsSet.VALUE_TYPE_RF));
        }
    }
}

