/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestedClaimsLookupFunction
extends AbstractAuthenticationRequestLookupFunction<OIDCClaimsRequest> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestedClaimsLookupFunction.class);

    @Override
    protected OIDCClaimsRequest doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("claims") != null) {
                Object claims = this.getRequestObject().getJWTClaimsSet().getClaim("claims");
                if (claims instanceof Map) {
                    this.log.debug("claims claim is a map, converting it into a JSONObject");
                    return OIDCClaimsRequest.parse((JSONObject)new JSONObject((Map)claims));
                }
                this.log.error("claims claim is not of expected type (java.util.Map), it's: {}", claims.getClass());
                return null;
            }
        }
        catch (ParseException | java.text.ParseException e) {
            this.log.error("unable to parse claims claim {}", (Object)e.getMessage());
            return null;
        }
        return req.getOIDCClaims();
    }
}

